/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.lib.collection.ItemStackList;

public class StackHelper {
    @Nonnull
    public static ItemStack grow(@Nonnull ItemStack stack, int amount) {
        stack.func_190917_f(amount);
        return stack;
    }

    @Nonnull
    public static ItemStack shrink(@Nonnull ItemStack stack, int amount) {
        stack.func_190918_g(amount);
        return stack;
    }

    @Nonnull
    public static ItemStack safeCopy(@Nonnull ItemStack stack) {
        return stack.func_77946_l();
    }

    public static int getCount(@Nonnull ItemStack stack) {
        return stack.func_190916_E();
    }

    @Nonnull
    public static ItemStack setCount(@Nonnull ItemStack stack, int amount) {
        stack.func_190920_e(amount);
        if (amount <= 0) {
            return StackHelper.empty();
        }
        return stack;
    }

    public static boolean isEmpty(@Nonnull ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        return stack != null && !stack.func_190926_b();
    }

    @Nonnull
    public static ItemStack loadFromNBT(NBTTagCompound tags) {
        if (tags == null) {
            return StackHelper.empty();
        }
        return new ItemStack(tags);
    }

    @Nonnull
    public static ItemStack empty() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return StackHelper.empty();
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            capability.insertItem(slot, stack, false);
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    public static List<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }

    public static ItemStack getAndSplit(ItemStackList stacks, int index, int amount) {
        return ItemStackHelper.func_188382_a((List)((Object)stacks), (int)index, (int)amount);
    }

    public static ItemStack getAndRemove(ItemStackList stacks, int index) {
        return ItemStackHelper.func_188383_a((List)((Object)stacks), (int)index);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks) {
        return StackHelper.saveAllItems(tags, stacks, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tags, ItemStackList stacks, boolean p_191281_2_) {
        return ItemStackHelper.func_191281_a((NBTTagCompound)tags, (NonNullList)stacks, (boolean)p_191281_2_);
    }

    public static void loadAllItems(NBTTagCompound tags, ItemStackList stacks) {
        ItemStackHelper.func_191283_b((NBTTagCompound)tags, (NonNullList)stacks);
    }
}

