/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.world;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class WorldGeneratorSL
implements IWorldGenerator {
    public final boolean allowRetrogen;
    public final String retrogenKey;

    public WorldGeneratorSL(boolean allowRetrogren, String retrogenKey) {
        this.allowRetrogen = allowRetrogren;
        this.retrogenKey = retrogenKey;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    protected abstract void generateSurface(World var1, Random var2, int var3, int var4);

    protected abstract void generateNether(World var1, Random var2, int var3, int var4);

    protected abstract void generateEnd(World var1, Random var2, int var3, int var4);

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (!this.allowRetrogen) {
            return;
        }
    }
}

