/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.utils;

import com.google.common.primitives.UnsignedInts;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.silentchaos512.utils.MathUtils;

public class Color {
    private static final Map<String, Color> NAMED_MAP = new HashMap<String, Color>();
    private static final Pattern PATTERN_LEADING_JUNK = Pattern.compile("(#|0x)", 2);
    private static final Pattern PATTERN_HEX_CODE = Pattern.compile("(#|0x)?[0-9a-f]{1,8}", 2);
    public static final int VALUE_WHITE = 0xFFFFFF;
    public static final Color ALICEBLUE = Color.named("AliceBlue", 0xF0F8FF);
    public static final Color ANTIQUEWHITE = Color.named("AntiqueWhite", 16444375);
    public static final Color AQUA = Color.named("Aqua", 65535);
    public static final Color AQUAMARINE = Color.named("Aquamarine", 8388564);
    public static final Color AZURE = Color.named("Azure", 0xF0FFFF);
    public static final Color BEIGE = Color.named("Beige", 16119260);
    public static final Color BISQUE = Color.named("Bisque", 16770244);
    public static final Color BLACK = Color.named("Black", 0);
    public static final Color BLANCHEDALMOND = Color.named("BlanchedAlmond", 16772045);
    public static final Color BLUE = Color.named("Blue", 255);
    public static final Color BLUEVIOLET = Color.named("BlueViolet", 9055202);
    public static final Color BROWN = Color.named("Brown", 0xA52A2A);
    public static final Color BURLYWOOD = Color.named("BurlyWood", 14596231);
    public static final Color CADETBLUE = Color.named("CadetBlue", 6266528);
    public static final Color CHARTREUSE = Color.named("Chartreuse", 0x7FFF00);
    public static final Color CHOCOLATE = Color.named("Chocolate", 13789470);
    public static final Color CORAL = Color.named("Coral", 16744272);
    public static final Color CORNFLOWERBLUE = Color.named("CornflowerBlue", 6591981);
    public static final Color CORNSILK = Color.named("Cornsilk", 16775388);
    public static final Color CRIMSON = Color.named("Crimson", 14423100);
    public static final Color CYAN = Color.named("Cyan", 65535);
    public static final Color DARKBLUE = Color.named("DarkBlue", 139);
    public static final Color DARKCYAN = Color.named("DarkCyan", 35723);
    public static final Color DARKGOLDENROD = Color.named("DarkGoldenRod", 12092939);
    public static final Color DARKGRAY = Color.named("DarkGray", 0xA9A9A9);
    public static final Color DARKGREY = Color.named("DarkGrey", 0xA9A9A9);
    public static final Color DARKGREEN = Color.named("DarkGreen", 25600);
    public static final Color DARKKHAKI = Color.named("DarkKhaki", 12433259);
    public static final Color DARKMAGENTA = Color.named("DarkMagenta", 0x8B008B);
    public static final Color DARKOLIVEGREEN = Color.named("DarkOliveGreen", 5597999);
    public static final Color DARKORANGE = Color.named("DarkOrange", 16747520);
    public static final Color DARKORCHID = Color.named("DarkOrchid", 10040012);
    public static final Color DARKRED = Color.named("DarkRed", 0x8B0000);
    public static final Color DARKSALMON = Color.named("DarkSalmon", 15308410);
    public static final Color DARKSEAGREEN = Color.named("DarkSeaGreen", 9419919);
    public static final Color DARKSLATEBLUE = Color.named("DarkSlateBlue", 4734347);
    public static final Color DARKSLATEGRAY = Color.named("DarkSlateGray", 0x2F4F4F);
    public static final Color DARKSLATEGREY = Color.named("DarkSlateGrey", 0x2F4F4F);
    public static final Color DARKTURQUOISE = Color.named("DarkTurquoise", 52945);
    public static final Color DARKVIOLET = Color.named("DarkViolet", 9699539);
    public static final Color DEEPPINK = Color.named("DeepPink", 16716947);
    public static final Color DEEPSKYBLUE = Color.named("DeepSkyBlue", 49151);
    public static final Color DIMGRAY = Color.named("DimGray", 0x696969);
    public static final Color DIMGREY = Color.named("DimGrey", 0x696969);
    public static final Color DODGERBLUE = Color.named("DodgerBlue", 2003199);
    public static final Color FIREBRICK = Color.named("FireBrick", 0xB22222);
    public static final Color FLORALWHITE = Color.named("FloralWhite", 0xFFFAF0);
    public static final Color FORESTGREEN = Color.named("ForestGreen", 0x228B22);
    public static final Color FUCHSIA = Color.named("Fuchsia", 0xFF00FF);
    public static final Color GAINSBORO = Color.named("Gainsboro", 0xDCDCDC);
    public static final Color GHOSTWHITE = Color.named("GhostWhite", 0xF8F8FF);
    public static final Color GOLD = Color.named("Gold", 16766720);
    public static final Color GOLDENROD = Color.named("GoldenRod", 14329120);
    public static final Color GRAY = Color.named("Gray", 0x808080);
    public static final Color GREY = Color.named("Grey", 0x808080);
    public static final Color GREEN = Color.named("Green", 32768);
    public static final Color GREENYELLOW = Color.named("GreenYellow", 11403055);
    public static final Color HONEYDEW = Color.named("HoneyDew", 0xF0FFF0);
    public static final Color HOTPINK = Color.named("HotPink", 16738740);
    public static final Color INDIANRED = Color.named("IndianRed", 0xCD5C5C);
    public static final Color INDIGO = Color.named("Indigo", 4915330);
    public static final Color IVORY = Color.named("Ivory", 0xFFFFF0);
    public static final Color KHAKI = Color.named("Khaki", 15787660);
    public static final Color LAVENDER = Color.named("Lavender", 15132410);
    public static final Color LAVENDERBLUSH = Color.named("LavenderBlush", 0xFFF0F5);
    public static final Color LAWNGREEN = Color.named("LawnGreen", 8190976);
    public static final Color LEMONCHIFFON = Color.named("LemonChiffon", 16775885);
    public static final Color LIGHTBLUE = Color.named("LightBlue", 11393254);
    public static final Color LIGHTCORAL = Color.named("LightCoral", 0xF08080);
    public static final Color LIGHTCYAN = Color.named("LightCyan", 0xE0FFFF);
    public static final Color LIGHTGOLDENRODYELLOW = Color.named("LightGoldenRodYellow", 16448210);
    public static final Color LIGHTGRAY = Color.named("LightGray", 0xD3D3D3);
    public static final Color LIGHTGREY = Color.named("LightGrey", 0xD3D3D3);
    public static final Color LIGHTGREEN = Color.named("LightGreen", 0x90EE90);
    public static final Color LIGHTPINK = Color.named("LightPink", 16758465);
    public static final Color LIGHTSALMON = Color.named("LightSalmon", 16752762);
    public static final Color LIGHTSEAGREEN = Color.named("LightSeaGreen", 2142890);
    public static final Color LIGHTSKYBLUE = Color.named("LightSkyBlue", 8900346);
    public static final Color LIGHTSLATEGRAY = Color.named("LightSlateGray", 0x778899);
    public static final Color LIGHTSLATEGREY = Color.named("LightSlateGrey", 0x778899);
    public static final Color LIGHTSTEELBLUE = Color.named("LightSteelBlue", 11584734);
    public static final Color LIGHTYELLOW = Color.named("LightYellow", 0xFFFFE0);
    public static final Color LIME = Color.named("Lime", 65280);
    public static final Color LIMEGREEN = Color.named("LimeGreen", 3329330);
    public static final Color LINEN = Color.named("Linen", 16445670);
    public static final Color MAGENTA = Color.named("Magenta", 0xFF00FF);
    public static final Color MAROON = Color.named("Maroon", 0x800000);
    public static final Color MEDIUMAQUAMARINE = Color.named("MediumAquaMarine", 6737322);
    public static final Color MEDIUMBLUE = Color.named("MediumBlue", 205);
    public static final Color MEDIUMORCHID = Color.named("MediumOrchid", 12211667);
    public static final Color MEDIUMPURPLE = Color.named("MediumPurple", 9662683);
    public static final Color MEDIUMSEAGREEN = Color.named("MediumSeaGreen", 3978097);
    public static final Color MEDIUMSLATEBLUE = Color.named("MediumSlateBlue", 8087790);
    public static final Color MEDIUMSPRINGGREEN = Color.named("MediumSpringGreen", 64154);
    public static final Color MEDIUMTURQUOISE = Color.named("MediumTurquoise", 4772300);
    public static final Color MEDIUMVIOLETRED = Color.named("MediumVioletRed", 13047173);
    public static final Color MIDNIGHTBLUE = Color.named("MidnightBlue", 1644912);
    public static final Color MINTCREAM = Color.named("MintCream", 0xF5FFFA);
    public static final Color MISTYROSE = Color.named("MistyRose", 16770273);
    public static final Color MOCCASIN = Color.named("Moccasin", 16770229);
    public static final Color NAVAJOWHITE = Color.named("NavajoWhite", 16768685);
    public static final Color NAVY = Color.named("Navy", 128);
    public static final Color OLDLACE = Color.named("OldLace", 16643558);
    public static final Color OLIVE = Color.named("Olive", 0x808000);
    public static final Color OLIVEDRAB = Color.named("OliveDrab", 7048739);
    public static final Color ORANGE = Color.named("Orange", 16753920);
    public static final Color ORANGERED = Color.named("OrangeRed", 16729344);
    public static final Color ORCHID = Color.named("Orchid", 14315734);
    public static final Color PALEGOLDENROD = Color.named("PaleGoldenRod", 0xEEE8AA);
    public static final Color PALEGREEN = Color.named("PaleGreen", 10025880);
    public static final Color PALETURQUOISE = Color.named("PaleTurquoise", 0xAFEEEE);
    public static final Color PALEVIOLETRED = Color.named("PaleVioletRed", 14381203);
    public static final Color PAPAYAWHIP = Color.named("PapayaWhip", 16773077);
    public static final Color PEACHPUFF = Color.named("PeachPuff", 16767673);
    public static final Color PERU = Color.named("Peru", 13468991);
    public static final Color PINK = Color.named("Pink", 16761035);
    public static final Color PLUM = Color.named("Plum", 0xDDA0DD);
    public static final Color POWDERBLUE = Color.named("PowderBlue", 11591910);
    public static final Color PURPLE = Color.named("Purple", 0x800080);
    public static final Color REBECCAPURPLE = Color.named("RebeccaPurple", 0x663399);
    public static final Color RED = Color.named("Red", 0xFF0000);
    public static final Color ROSYBROWN = Color.named("RosyBrown", 12357519);
    public static final Color ROYALBLUE = Color.named("RoyalBlue", 4286945);
    public static final Color SADDLEBROWN = Color.named("SaddleBrown", 9127187);
    public static final Color SALMON = Color.named("Salmon", 16416882);
    public static final Color SANDYBROWN = Color.named("SandyBrown", 16032864);
    public static final Color SEAGREEN = Color.named("SeaGreen", 3050327);
    public static final Color SEASHELL = Color.named("SeaShell", 0xFFF5EE);
    public static final Color SIENNA = Color.named("Sienna", 10506797);
    public static final Color SILVER = Color.named("Silver", 0xC0C0C0);
    public static final Color SKYBLUE = Color.named("SkyBlue", 8900331);
    public static final Color SLATEBLUE = Color.named("SlateBlue", 6970061);
    public static final Color SLATEGRAY = Color.named("SlateGray", 7372944);
    public static final Color SLATEGREY = Color.named("SlateGrey", 7372944);
    public static final Color SNOW = Color.named("Snow", 0xFFFAFA);
    public static final Color SPRINGGREEN = Color.named("SpringGreen", 65407);
    public static final Color STEELBLUE = Color.named("SteelBlue", 4620980);
    public static final Color TAN = Color.named("Tan", 13808780);
    public static final Color TEAL = Color.named("Teal", 32896);
    public static final Color THISTLE = Color.named("Thistle", 14204888);
    public static final Color TOMATO = Color.named("Tomato", 16737095);
    public static final Color TURQUOISE = Color.named("Turquoise", 4251856);
    public static final Color VIOLET = Color.named("Violet", 0xEE82EE);
    public static final Color WHEAT = Color.named("Wheat", 16113331);
    public static final Color WHITE = Color.named("White", 0xFFFFFF);
    public static final Color WHITESMOKE = Color.named("WhiteSmoke", 0xF5F5F5);
    public static final Color YELLOW = Color.named("Yellow", 0xFFFF00);
    public static final Color YELLOWGREEN = Color.named("YellowGreen", 10145074);
    private final int color;
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public Color(int color) {
        this.color = color;
        this.alpha = color >> 24 & 0xFF;
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
    }

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Color(int red, int green, int blue, int alpha) {
        this.color = (alpha & 0xFF) << 24 & (red & 0xFF) << 16 & (green & 0xFF) << 8 & (blue & 0xFF);
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    private static Color named(String name, int color) {
        Color c = new Color(color);
        NAMED_MAP.put(name.toLowerCase(Locale.ROOT), c);
        return c;
    }

    public static boolean validate(String str) {
        return NAMED_MAP.containsKey(str.toLowerCase(Locale.ROOT)) || PATTERN_HEX_CODE.matcher(str).matches();
    }

    public static String format(int color) {
        return String.format(color > 0xFFFFFF ? "#%08X" : "#%06X", color);
    }

    public static Color parse(String str) {
        if (NAMED_MAP.containsKey(str = str.toLowerCase(Locale.ROOT))) {
            return NAMED_MAP.get(str);
        }
        str = PATTERN_LEADING_JUNK.matcher(str).replaceFirst("");
        int color = UnsignedInts.parseUnsignedInt((String)str, (int)16);
        return new Color(color);
    }

    public static Color tryParse(String str, int defaultValue) {
        if (!Color.validate(str)) {
            return new Color(defaultValue);
        }
        return Color.parse(str);
    }

    public static Color from(JsonObject json, String propertyName, int defaultValue) {
        String defaultStr = Integer.toHexString(defaultValue);
        JsonElement element = json.get(propertyName);
        return Color.parse(element.isJsonPrimitive() ? element.getAsString() : defaultStr);
    }

    public Color blendWith(Color other) {
        return Color.blend(this, other);
    }

    public static Color blend(Color color1, Color color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static Color blend(Color color1, Color color2, float ratio) {
        int i1 = color1.getColor();
        int i2 = color2.getColor();
        int color = Color.blend(i1, i2, ratio);
        return new Color(color);
    }

    public static int blend(int color1, int color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static int blend(int color1, int color2, float ratio) {
        ratio = MathUtils.clamp(ratio, 0.0f, 1.0f);
        float iRatio = 1.0f - ratio;
        int a1 = color1 >> 24 & 0xFF;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public int getColor() {
        int r = (int)((float)this.red * 255.0f) << 16;
        int g = (int)((float)this.green * 255.0f) << 8;
        int b = (int)((float)this.blue * 255.0f);
        return r + g + b;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRedInt() {
        return (int)((float)this.red * 255.0f);
    }

    public int getGreenInt() {
        return (int)((float)this.green * 255.0f);
    }

    public int getBlueInt() {
        return (int)((float)this.blue * 255.0f);
    }

    public int getAlphaInt() {
        return (int)((float)this.alpha * 255.0f);
    }
}

