/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.silentchaos512.lib.block.BlockContainerSL;
import net.silentchaos512.lib.block.BlockSL;
import net.silentchaos512.lib.item.ItemBlockSL;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.IRegistryObject;

public class SRegistry {
    private final Map<String, Block> blocks = Maps.newHashMap();
    private final Map<String, Item> items = Maps.newHashMap();
    private final List<IRegistryObject> registryObjects = Lists.newArrayList();
    public final String modId;
    public final String resourcePrefix;

    public SRegistry(String modId) {
        this.modId = modId;
        this.resourcePrefix = modId.toLowerCase() + ":";
    }

    public Block registerBlock(BlockSL block) {
        return this.registerBlock((Block)block, block.getName());
    }

    public Block registerBlock(BlockContainerSL block) {
        return this.registerBlock((Block)block, block.getName());
    }

    public Block registerBlock(Block block, String key) {
        return this.registerBlock(block, key, new ItemBlockSL(block));
    }

    public Block registerBlock(BlockSL block, ItemBlock itemBlock) {
        return this.registerBlock(block, block.getName(), itemBlock);
    }

    public Block registerBlock(BlockContainerSL block, ItemBlock itemBlock) {
        return this.registerBlock((Block)block, block.getName(), itemBlock);
    }

    public Block registerBlock(Block block, String key, ItemBlock itemBlock) {
        this.blocks.put(key, block);
        if (block instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)block);
        }
        ResourceLocation resource = new ResourceLocation(this.resourcePrefix + key);
        block.setRegistryName(resource);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock, (ResourceLocation)resource);
        return block;
    }

    public Item registerItem(ItemSL item) {
        return this.registerItem(item, item.getName());
    }

    public Item registerItem(Item item, String key) {
        this.items.put(key, item);
        if (item instanceof IRegistryObject) {
            this.registryObjects.add((IRegistryObject)item);
        }
        ResourceLocation resource = new ResourceLocation(this.resourcePrefix + key);
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)resource);
        return item;
    }

    public void registerTileEntity(Class<? extends TileEntity> tileClass, String key) {
        GameRegistry.registerTileEntity(tileClass, (String)("tile." + this.resourcePrefix + key));
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void registerTileEntitySpecialRenderer(Class<T> tileClass, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(entityClass, renderer);
    }

    public IRecipe addRecipeHandler(Class<? extends IRecipe> recipeClass, String name, RecipeSorter.Category category, String dependencies) throws InstantiationException, IllegalAccessException {
        IRecipe recipe = recipeClass.newInstance();
        GameRegistry.addRecipe((IRecipe)recipe);
        RecipeSorter.register((String)(this.resourcePrefix + name), recipeClass, (RecipeSorter.Category)category, (String)dependencies);
        return recipe;
    }

    public Block getBlock(String key) {
        return this.blocks.get(key);
    }

    public Item getItem(String key) {
        return this.items.get(key);
    }

    public void preInit() {
    }

    public void init() {
        this.addRecipesAndOreDictEntries();
    }

    public void postInit() {
    }

    public void clientPreInit() {
        this.registerModelVariants();
    }

    public void clientInit() {
        this.registerModels();
    }

    public void clientPostInit() {
    }

    protected void addRecipesAndOreDictEntries() {
        for (IRegistryObject obj : this.registryObjects) {
            obj.addOreDict();
            obj.addRecipes();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModelVariants() {
        for (IRegistryObject obj : this.registryObjects) {
            Item item = obj instanceof Block ? Item.func_150898_a((Block)((Block)obj)) : (Item)obj;
            List<ModelResourceLocation> models = obj.getVariants();
            ArrayList nonNullModels = Lists.newArrayList();
            for (ModelResourceLocation m : models) {
                if (m == null) continue;
                nonNullModels.add(m);
            }
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])((ResourceLocation[])nonNullModels.toArray(new ModelResourceLocation[nonNullModels.size()])));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModels() {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (IRegistryObject obj : this.registryObjects) {
            if (obj.registerModels()) continue;
            Item item = obj instanceof Block ? Item.func_150898_a((Block)((Block)obj)) : (Item)obj;
            List<ModelResourceLocation> models = obj.getVariants();
            for (int i = 0; i < models.size(); ++i) {
                if (models.get(i) == null) continue;
                mesher.func_178086_a(item, i, models.get(i));
            }
        }
    }
}

