/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.render;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.silentchaos512.lib.client.model.ILayeredBakedModel;
import net.silentchaos512.lib.item.ICustomEnchantColor;

@ParametersAreNonnullByDefault
public class TEISRCustomEnchantedEffect
extends TileEntityItemStackRenderer {
    public static final TEISRCustomEnchantedEffect INSTANCE = new TEISRCustomEnchantedEffect();
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ImmutableSet<EnumFacing> EMPTY = ImmutableSet.of();
    private static final ImmutableSet<EnumFacing> STUPID_FACES = ImmutableSet.of((Object)EnumFacing.SOUTH, (Object)EnumFacing.NORTH);
    private static final Random RANDOM = new Random();

    private TEISRCustomEnchantedEffect() {
    }

    public void func_179022_a(ItemStack stack) {
        int i;
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        if (!(model instanceof ILayeredBakedModel)) {
            throw new IllegalArgumentException("Model must be a ILayeredBakedModel");
        }
        int effectColor = this.getEffectColor(stack);
        int layerCount = ((ILayeredBakedModel)model).getLayerCount();
        for (i = 0; i < layerCount; ++i) {
            this.renderModelExcluding(model, -1, stack, i, (Collection<EnumFacing>)EMPTY);
        }
        if (stack.func_77962_s()) {
            this.renderEffectExcluding(model, effectColor, 0, (Collection<EnumFacing>)EMPTY);
            for (i = 1; i < layerCount; ++i) {
                this.renderEffectExcluding(model, effectColor, i, (Collection<EnumFacing>)STUPID_FACES);
            }
        }
    }

    private int getEffectColor(ItemStack stack) {
        int effectColor = 8405196;
        if (stack.func_77973_b() instanceof ICustomEnchantColor) {
            int maxBrightness;
            int b;
            int g;
            int r;
            int total;
            ICustomEnchantColor item = (ICustomEnchantColor)stack.func_77973_b();
            effectColor = item.getEffectColor(stack);
            if (item.shouldTruncateBrightness(stack) && (total = (r = effectColor >> 16 & 0xFF) + (g = effectColor >> 8 & 0xFF) + (b = effectColor & 0xFF)) > (maxBrightness = item.getEffectMaxBrightness(stack))) {
                float scale = (float)maxBrightness / (float)total;
                r = (int)((float)r * scale);
                g = (int)((float)g * scale);
                b = (int)((float)b * scale);
                effectColor = (r << 16) + (g << 8) + b;
            }
        }
        return effectColor;
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private void renderEffectExcluding(IBakedModel model, int effectColor, int layerIndex, Collection<EnumFacing> excludeFaces) {
        int color = effectColor | 0xFF000000;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModelExcluding(model, color, layerIndex, excludeFaces);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModelExcluding(model, color, layerIndex, excludeFaces);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private void renderModelExcluding(IBakedModel model, int color, int layerIndex, Collection<EnumFacing> excludeFaces) {
        this.renderModelExcluding(model, color, ItemStack.field_190927_a, layerIndex, excludeFaces);
    }

    private void renderModelExcluding(IBakedModel model, int color, ItemStack stack, int layerIndex, Collection<EnumFacing> excludeFaces) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layerIndex < 0) {
            for (int i = 0; i < ((ILayeredBakedModel)model).getLayerCount(); ++i) {
                for (BakedQuad quad : model.func_200117_a(null, null, RANDOM)) {
                    if (excludeFaces.contains(quad.func_178210_d())) continue;
                    quads.add(quad);
                }
            }
        } else {
            for (BakedQuad quad : model.func_200117_a(null, null, RANDOM)) {
                if (excludeFaces.contains(quad.func_178210_d())) continue;
                quads.add(quad);
            }
        }
        this.renderQuads(bufferbuilder, quads, color, stack);
        tessellator.func_78381_a();
    }
}

