/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeConfigSpec;

@Deprecated
public final class ConfigValueOreGen {
    private ForgeConfigSpec.DoubleValue veinCount;
    private ForgeConfigSpec.DoubleValue veinSize;
    private ForgeConfigSpec.IntValue minY;
    private ForgeConfigSpec.IntValue maxY;
    private ForgeConfigSpec.IntValue dimension;
    private ForgeConfigSpec.ConfigValue<List<? extends Integer>> dimensionBlacklist;

    private ConfigValueOreGen() {
    }

    public static ConfigValueOreGen define(ForgeConfigSpec.Builder config, String path, String comment, Builder defaults) {
        config.comment(comment);
        config.push(path);
        ConfigValueOreGen result = new ConfigValueOreGen();
        result.veinCount = config.comment("Number of veins per chunk on average").defineInRange("veinCount", defaults.veinCount, 0.0, 1000.0);
        result.veinSize = config.comment("The size of each ore vein").defineInRange("veinSize", defaults.veinSize, 0.0, 1000.0);
        result.minY = config.comment("The lowest level the ore will spawn at").defineInRange("minY", defaults.minY, 0, 255);
        result.maxY = config.comment("The highest level the ore will spawn at").defineInRange("maxY", defaults.maxY, (Integer)result.minY.get() + 1, 255);
        result.dimension = config.defineInRange("dimension", defaults.dimension, Integer.MIN_VALUE, Integer.MAX_VALUE);
        result.dimensionBlacklist = config.defineList("dimensionBlacklist", defaults.dimensionBlacklist, o -> o instanceof Integer);
        config.pop();
        return result;
    }

    public boolean canSpawnIn(int dimension) {
        if (dimension != 0) {
            return dimension == (Integer)this.dimension.get();
        }
        Iterator iterator = ((List)this.dimensionBlacklist.get()).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i != dimension) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return (Double)this.veinCount.get() > 0.0 && (Double)this.veinSize.get() > 0.0;
    }

    public BlockPos selectPos(Random random, int chunkCenterX, int chunkCenterZ) {
        return new BlockPos(chunkCenterX + random.nextInt(16), (Integer)this.minY.get() + random.nextInt((Integer)this.maxY.get() - (Integer)this.minY.get()), chunkCenterZ + random.nextInt(16));
    }

    public int veinCount(Random random) {
        double diff = (Double)this.veinCount.get() - (double)((Double)this.veinCount.get()).intValue();
        return ((Double)this.veinCount.get()).intValue() + ((double)random.nextFloat() < diff ? 1 : 0);
    }

    public static class Builder {
        private double veinCount = 8.0;
        private double veinSize = 8.0;
        private int minY = 0;
        private int maxY = 128;
        private int dimension = 0;
        private final List<Integer> dimensionBlacklist = new ArrayList<Integer>();

        public static Builder create() {
            return new Builder();
        }

        public Builder veinCountSize(double count, double size) {
            this.veinCount = count;
            this.veinSize = size;
            return this;
        }

        public Builder height(int min, int max) {
            if (max <= min) {
                throw new IllegalArgumentException("max must be greater than min");
            }
            this.minY = min;
            this.maxY = max;
            return this;
        }

        public Builder dimension(int dim) {
            this.dimension = dim;
            return this;
        }

        public Builder dimension(int dim, int ... blacklist) {
            this.dimension = dim;
            this.dimensionBlacklist.clear();
            for (int i : blacklist) {
                this.dimensionBlacklist.add(i);
            }
            return this;
        }
    }
}

