/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class ExtendedShapelessRecipe
extends ShapelessRecipe {
    private final ShapelessRecipe recipe;

    public ExtendedShapelessRecipe(ShapelessRecipe recipe) {
        super(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), recipe.func_192400_c());
        this.recipe = recipe;
    }

    public ShapelessRecipe getBaseRecipe() {
        return this.recipe;
    }

    public abstract IRecipeSerializer<?> func_199559_b();

    public abstract boolean func_77569_a(IInventory var1, World var2);

    public abstract ItemStack func_77572_b(IInventory var1);

    public static class Serializer<T extends ExtendedShapelessRecipe>
    implements IRecipeSerializer<T> {
        private final ResourceLocation serializerId;
        private final Function<ShapelessRecipe, T> recipeFactory;
        @Nullable
        private final BiConsumer<JsonObject, T> readJson;
        @Nullable
        private final BiConsumer<PacketBuffer, T> readBuffer;
        @Nullable
        private final BiConsumer<PacketBuffer, T> writeBuffer;

        public Serializer(ResourceLocation serializerId, Function<ShapelessRecipe, T> recipeFactory, @Nullable BiConsumer<JsonObject, T> readJson, @Nullable BiConsumer<PacketBuffer, T> readBuffer, @Nullable BiConsumer<PacketBuffer, T> writeBuffer) {
            this.serializerId = serializerId;
            this.recipeFactory = recipeFactory;
            this.readJson = readJson;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        public static <S extends ExtendedShapelessRecipe> Serializer<S> basic(ResourceLocation serializerId, Function<ShapelessRecipe, S> recipeFactory) {
            return new Serializer<S>(serializerId, recipeFactory, null, null, null);
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = (ShapelessRecipe)RecipeSerializers.field_199576_b.func_199425_a_(recipeId, json);
            ExtendedShapelessRecipe result = (ExtendedShapelessRecipe)((Object)this.recipeFactory.apply(recipe));
            if (this.readJson != null) {
                this.readJson.accept(json, (JsonObject)result);
            }
            return (T)((Object)result);
        }

        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = (ShapelessRecipe)RecipeSerializers.field_199576_b.func_199426_a_(recipeId, buffer);
            ExtendedShapelessRecipe result = (ExtendedShapelessRecipe)((Object)this.recipeFactory.apply(recipe));
            if (this.readBuffer != null) {
                this.readBuffer.accept(buffer, (PacketBuffer)result);
            }
            return (T)((Object)result);
        }

        public void write(PacketBuffer buffer, T recipe) {
            RecipeSerializers.field_199576_b.func_199427_a_(buffer, (IRecipe)((ExtendedShapelessRecipe)((Object)recipe)).getBaseRecipe());
            if (this.writeBuffer != null) {
                this.writeBuffer.accept(buffer, (PacketBuffer)recipe);
            }
        }

        public ResourceLocation getName() {
            return this.serializerId;
        }
    }
}

