/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.inventory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.fml.network.NetworkHooks;

public interface ContainerType<T extends Container>
extends IInteractionObject {
    public static final Map<ResourceLocation, Supplier<? extends ContainerType<?>>> factories = new ConcurrentHashMap();
    public static final Map<ResourceLocation, BiFunction<? extends ContainerType<?>, EntityPlayer, GuiContainer>> guiFactories = new ConcurrentHashMap();
    public static final Map<ResourceLocation, BiFunction<? extends ContainerType<?>, EntityPlayer, ? extends Container>> containerFactories = new ConcurrentHashMap();

    public ResourceLocation getId();

    public void toBytes(PacketBuffer var1);

    public void fromBytes(PacketBuffer var1);

    default public T func_174876_a(InventoryPlayer inventoryPlayer, EntityPlayer entityPlayer) {
        return (T)containerFactories.get(this.getId()).apply(this, entityPlayer);
    }

    default public String func_174875_k() {
        return this.getId().toString();
    }

    default public ITextComponent func_200200_C_() {
        ResourceLocation id = this.getId();
        return new TextComponentTranslation("container." + id.func_110624_b() + "." + id.func_110623_a(), new Object[0]);
    }

    default public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    default public ITextComponent func_200201_e() {
        return null;
    }

    default public void open(EntityPlayer player) {
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)this, this::toBytes);
    }

    public static <C extends Container, T extends ContainerType<C>> void register(Supplier<T> containerType, BiFunction<T, EntityPlayer, C> factory) {
        factories.put(((ContainerType)containerType.get()).getId(), containerType);
        containerFactories.put(((ContainerType)containerType.get()).getId(), factory);
    }

    public static <C extends Container, T extends ContainerType<C>> void registerGui(Supplier<T> containerType, BiFunction<T, EntityPlayer, GuiContainer> factory) {
        guiFactories.put(((ContainerType)containerType.get()).getId(), factory);
    }

    public static <C extends Container, T extends ContainerType<C>> void registerGui(Supplier<T> containerType, Function<C, GuiContainer> factory) {
        ContainerType.registerGui(containerType, (T type, EntityPlayer player) -> {
            Container container = containerFactories.get(type.getId()).apply((ContainerType<?>)type, (EntityPlayer)player);
            return container == null ? null : (GuiContainer)factory.apply(container);
        });
    }
}

