/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.network;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.silentchaos512.lib.util.resourcemanager.IReloadableResource;
import net.silentchaos512.lib.util.resourcemanager.ResourceManagerBase;

public abstract class SyncResourcesPacket<T extends IReloadableResource<T>> {
    private List<T> list;

    public SyncResourcesPacket() {
    }

    public SyncResourcesPacket(Collection<T> objects) {
        this.list = new ArrayList<T>(objects);
    }

    public void fromBytes(PacketBuffer buffer, Function<PacketBuffer, T> reader) {
        this.list = new ArrayList<T>();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            this.list.add(reader.apply(buffer));
        }
    }

    public void toBytes(PacketBuffer buffer, BiConsumer<PacketBuffer, T> writer) {
        buffer.func_150787_b(this.list.size());
        this.list.forEach(obj -> writer.accept(buffer, obj));
    }

    public List<T> getResources() {
        return Collections.unmodifiableList(this.list);
    }

    public static <T extends IReloadableResource<T>, M extends ResourceManagerBase<T>, P extends SyncResourcesPacket<T>> void register(SimpleChannel channel, int id, boolean markAsLoginPacket, M resourceManager, Class<P> packetClass) {
        SimpleChannel.MessageBuilder builder = channel.messageBuilder(packetClass, id);
        builder.decoder(buffer -> {
            Object packet = SyncResourcesPacket.constructPacket(packetClass);
            ((SyncResourcesPacket)packet).fromBytes((PacketBuffer)buffer, resourceManager::deserialize);
            return packet;
        });
        builder.encoder((packet, buffer) -> packet.toBytes((PacketBuffer)buffer, (buf, obj) -> resourceManager.serialize((PacketBuffer)buf, obj)));
        builder.consumer(resourceManager::onSyncPacket);
        if (markAsLoginPacket) {
            builder.markAsLoginPacket();
        }
        builder.add();
    }

    private static <T extends IReloadableResource<T>, P extends SyncResourcesPacket<T>> P constructPacket(Class<P> packetClass) {
        try {
            return (P)((SyncResourcesPacket)packetClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("SyncResourcesPacket must have a public constructor with no parameters", e);
        }
    }
}

