/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.network.internal;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.lib.util.EnumUtils;

public class LeftClickItemPacket {
    private ILeftClickItem.ClickType clickType;
    private EnumHand hand;

    public LeftClickItemPacket() {
        this.clickType = ILeftClickItem.ClickType.EMPTY;
        this.hand = EnumHand.MAIN_HAND;
    }

    public LeftClickItemPacket(ILeftClickItem.ClickType clickType, EnumHand hand) {
        this.clickType = clickType;
        this.hand = hand;
    }

    public ILeftClickItem.ClickType getClickType() {
        return this.clickType;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public static LeftClickItemPacket fromBytes(PacketBuffer buffer) {
        LeftClickItemPacket packet = new LeftClickItemPacket();
        packet.clickType = EnumUtils.byOrdinal(buffer.readByte(), ILeftClickItem.ClickType.EMPTY);
        packet.hand = buffer.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        return packet;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte(this.clickType.ordinal());
        buffer.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static void handle(LeftClickItemPacket packet, Supplier<NetworkEvent.Context> context) {
        ItemStack heldItem;
        EntityPlayerMP player = context.get().getSender();
        if (player != null && !(heldItem = player.func_184586_b(packet.hand)).func_190926_b() && heldItem.func_77973_b() instanceof ILeftClickItem) {
            ILeftClickItem item = (ILeftClickItem)heldItem.func_77973_b();
            if (packet.clickType == ILeftClickItem.ClickType.EMPTY) {
                item.onItemLeftClickSL(player.field_70170_p, (EntityPlayer)player, packet.hand);
            } else if (packet.clickType == ILeftClickItem.ClickType.BLOCK) {
                item.onItemLeftClickBlockSL(player.field_70170_p, (EntityPlayer)player, packet.hand);
            } else {
                SilentLib.LOGGER.error("Unknown ILeftClickItem.ClickType: {}", (Object)packet.clickType);
            }
        }
        context.get().setPacketHandled(true);
    }
}

