/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class DimPos {
    public static final DimPos ZERO = new DimPos(0, 0, 0, 0);
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int dimension;

    public static DimPos of(BlockPos pos, int dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, int dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.func_180425_c(), entity.field_71093_bK.func_186068_a());
    }

    private DimPos(BlockPos pos, int dimension) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    private DimPos(int x, int y, int z, int dimension) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getZ() {
        return this.posZ;
    }

    public int getDimension() {
        return this.dimension;
    }

    public static DimPos read(NBTTagCompound tags) {
        return DimPos.of(tags.func_74762_e("posX"), tags.func_74762_e("posY"), tags.func_74762_e("posZ"), tags.func_74762_e("dim"));
    }

    public void write(NBTTagCompound tags) {
        tags.func_74768_a("posX", this.posX);
        tags.func_74768_a("posY", this.posY);
        tags.func_74768_a("posZ", this.posZ);
        tags.func_74768_a("dim", this.dimension);
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public DimPos offset(EnumFacing facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.func_82601_c() * n, this.posY + facing.func_96559_d() * n, this.posZ + facing.func_82599_e() * n, this.dimension);
    }

    public String toString() {
        return String.format("(%d, %d, %d, d%d)", this.posX, this.posY, this.posZ, this.dimension);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DimPos)) {
            return false;
        }
        DimPos pos = (DimPos)other;
        return pos.dimension == this.dimension && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension;
    }
}

