/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.silentchaos512.lib.util.MathUtils;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77978_p() != b.func_77978_p()) {
            return false;
        }
        return (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    public static ItemStack firstMatch(IInventory inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack mergeItem(IInventory inventory, int slotStart, int slotEndExclusive, ItemStack stack) {
        int i;
        if (inventory == null || stack.func_190926_b()) {
            return stack;
        }
        for (i = slotStart; i < slotEndExclusive && !stack.func_190926_b(); ++i) {
            ItemStack inSlot = inventory.func_70301_a(i);
            if (!InventoryUtils.canItemsStack(inSlot, stack)) continue;
            int amountCanFit = MathUtils.min(inSlot.func_77976_d() - inSlot.func_190916_E(), stack.func_190916_E(), inventory.func_70297_j_());
            inSlot.func_190917_f(amountCanFit);
            stack.func_190918_g(amountCanFit);
            inventory.func_70299_a(i, inSlot);
        }
        for (i = slotStart; i < slotEndExclusive && !stack.func_190926_b(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            int amountCanFit = MathUtils.min(stack.func_190916_E(), inventory.func_70297_j_());
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190920_e(amountCanFit);
            stack.func_190918_g(amountCanFit);
            inventory.func_70299_a(i, toInsert);
        }
        return stack;
    }

    public static Collection<ItemStack> mergeItems(IInventory inventory, int slotStart, int slotEndExclusive, Collection<ItemStack> stacks) {
        if (inventory == null && stacks.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder leftovers = ImmutableList.builder();
        for (ItemStack stack : stacks) {
            if ((stack = InventoryUtils.mergeItem(inventory, slotStart, slotEndExclusive, stack)).func_190926_b()) continue;
            leftovers.add((Object)stack);
        }
        return leftovers.build();
    }
}

