/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextRenderUtils {
    private TextRenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private static void render(FontRenderer fontRenderer, String text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            fontRenderer.func_175063_a(text, x, y, color);
        } else {
            fontRenderer.func_211126_b(text, x, y, color);
        }
    }

    public static void renderScaled(FontRenderer fontRenderer, String text, int x, int y, float scale, int color, boolean shadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        boolean oldUnicode = fontRenderer.func_78260_a();
        fontRenderer.func_78275_b(false);
        TextRenderUtils.render(fontRenderer, text, (float)x / scale, (float)y / scale, color, shadow);
        fontRenderer.func_78275_b(oldUnicode);
        GlStateManager.func_179121_F();
    }

    public static void renderSplit(FontRenderer fontRenderer, String text, int x, int y, int width, int color, boolean shadow) {
        List list = fontRenderer.func_78271_c(text, width);
        for (int i = 0; i < list.size(); ++i) {
            String line = (String)list.get(i);
            int yTranslated = y + i * fontRenderer.field_78288_b;
            TextRenderUtils.render(fontRenderer, line, x, yTranslated, color, shadow);
        }
    }

    public static void renderSplitScaled(FontRenderer fontRenderer, String text, int x, int y, float scale, int color, boolean shadow, int length) {
        List lines = fontRenderer.func_78271_c(text, (int)((float)length / scale));
        for (int i = 0; i < lines.size(); ++i) {
            int yTranslated = y + i * (int)((float)fontRenderer.field_78288_b * scale + 3.0f);
            TextRenderUtils.renderScaled(fontRenderer, (String)lines.get(i), x, yTranslated, scale, color, shadow);
        }
    }
}

