/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.block.IBlockProvider;

public final class TagGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<ResourceLocation, Collection<String>> BLOCKS = new ConcurrentHashMap<ResourceLocation, Collection<String>>();
    private static final Map<ResourceLocation, Collection<String>> ITEMS = new ConcurrentHashMap<ResourceLocation, Collection<String>>();

    private TagGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static Tag<Block> block(ResourceLocation tag, IBlockProvider block) {
        return TagGenerator.block(tag, block.asBlock());
    }

    public static Tag<Block> block(ResourceLocation tag, IBlockProvider first, IBlockProvider ... rest) {
        return TagGenerator.block(tag, first.asBlock(), (Block[])Arrays.stream(rest).map(IBlockProvider::asBlock).toArray(Block[]::new));
    }

    public static Tag<Block> block(ResourceLocation tag, Block block) {
        return TagGenerator.block(tag, Objects.requireNonNull(block.getRegistryName()).toString());
    }

    public static Tag<Block> block(ResourceLocation tag, Block first, Block ... rest) {
        return TagGenerator.block(tag, Objects.requireNonNull(first.getRegistryName()).toString(), (String[])Arrays.stream(rest).map(block -> Objects.requireNonNull(block.getRegistryName()).toString()).toArray(String[]::new));
    }

    public static Tag<Block> block(ResourceLocation tag, Tag<?> value) {
        return TagGenerator.block(tag, "#" + value.func_199886_b());
    }

    public static Tag<Block> block(ResourceLocation tag, String value) {
        Collection<String> blocks = TagGenerator.getBlocks(tag);
        blocks.add(value);
        return new BlockTags.Wrapper(tag);
    }

    public static Tag<Block> block(ResourceLocation tag, String first, String ... rest) {
        Collection<String> blocks = TagGenerator.getBlocks(tag);
        blocks.add(first);
        blocks.addAll(Arrays.asList(rest));
        return new BlockTags.Wrapper(tag);
    }

    public static Tag<Item> item(ResourceLocation tag, IItemProvider item) {
        return TagGenerator.item(tag, item.func_199767_j());
    }

    public static Tag<Item> item(ResourceLocation tag, IItemProvider first, IItemProvider ... rest) {
        return TagGenerator.item(tag, first.func_199767_j(), (Item[])Arrays.stream(rest).map(IItemProvider::func_199767_j).toArray(Item[]::new));
    }

    public static Tag<Item> item(ResourceLocation tag, Item item) {
        return TagGenerator.item(tag, Objects.requireNonNull(item.getRegistryName()).toString());
    }

    public static Tag<Item> item(ResourceLocation tag, Item first, Item ... rest) {
        return TagGenerator.item(tag, Objects.requireNonNull(first.getRegistryName()).toString(), (String[])Arrays.stream(rest).map(i -> Objects.requireNonNull(i.getRegistryName()).toString()).toArray(String[]::new));
    }

    public static Tag<Item> item(ResourceLocation tag, Tag<?> value) {
        return TagGenerator.item(tag, "#" + value.func_199886_b());
    }

    public static Tag<Item> item(ResourceLocation tag, String value) {
        Collection<String> items = TagGenerator.getItems(tag);
        items.add(value);
        return new ItemTags.Wrapper(tag);
    }

    public static Tag<Item> item(ResourceLocation tag, String first, String ... rest) {
        Collection<String> items = TagGenerator.getItems(tag);
        items.add(first);
        items.addAll(Arrays.asList(rest));
        return new ItemTags.Wrapper(tag);
    }

    private static Collection<String> getBlocks(ResourceLocation tag) {
        if (!BLOCKS.containsKey(tag)) {
            BLOCKS.put(tag, new HashSet());
        }
        return BLOCKS.get(tag);
    }

    private static Collection<String> getItems(ResourceLocation tag) {
        if (!ITEMS.containsKey(tag)) {
            ITEMS.put(tag, new HashSet());
        }
        return ITEMS.get(tag);
    }

    @Deprecated
    public static void generateFiles() {
        if (SilentLib.isDevBuild()) {
            BLOCKS.forEach((tag, blocks) -> TagGenerator.writeFile(tag, "blocks", blocks));
            ITEMS.forEach((tag, items) -> TagGenerator.writeFile(tag, "items", items));
        }
        BLOCKS.clear();
        ITEMS.clear();
    }

    private static JsonObject getJson(Iterable<String> values) {
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        JsonArray array = new JsonArray();
        values.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("values", (JsonElement)array);
        return json;
    }

    private static void writeFile(ResourceLocation tag, String subDir, Iterable<String> things) {
        String str = "output/data/" + tag.func_110624_b() + "/tags/" + subDir + "/" + tag.func_110623_a() + ".json";
        File output = new File(str);
        File directory = new File(output.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            SilentLib.LOGGER.error("Could not create directory: {}", (Object)directory.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(output);){
            JsonObject json = TagGenerator.getJson(things);
            GSON.toJson((JsonElement)json, (Appendable)writer);
            SilentLib.LOGGER.info("Wrote tag file {}", (Object)output.getAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

