/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util.resourcemanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.silentchaos512.lib.network.SyncResourcesPacket;
import net.silentchaos512.lib.util.resourcemanager.IReloadableResource;
import net.silentchaos512.lib.util.resourcemanager.IReloadableResourceSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class ResourceManagerBase<T extends IReloadableResource<T>>
implements IResourceManagerReloadListener {
    private final String modId;
    private final String dataPath;
    protected final Marker logMarker;
    protected final Logger logger;
    protected final Map<ResourceLocation, T> resources = new LinkedHashMap<ResourceLocation, T>();
    protected final Map<ResourceLocation, IReloadableResourceSerializer<T>> serializers = new ConcurrentHashMap<ResourceLocation, IReloadableResourceSerializer<T>>();

    public ResourceManagerBase(String modId, String dataPath, String logMarker, Logger logger) {
        this.modId = modId;
        this.dataPath = dataPath.endsWith("/") ? dataPath : dataPath + "/";
        this.logMarker = MarkerManager.getMarker((String)logMarker);
        this.logger = logger;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public T deserialize(ResourceLocation id, JsonObject json) {
        ResourceLocation type;
        IReloadableResourceSerializer<T> serializer;
        String typeStr = JsonUtils.func_151219_a((JsonObject)json, (String)"type", (String)"");
        if (typeStr.isEmpty()) {
            throw new JsonParseException("Missing required property 'type' in resource " + id);
        }
        if (!typeStr.contains(":")) {
            typeStr = this.modId + ":" + typeStr;
        }
        if ((serializer = this.serializers.get(type = new ResourceLocation(typeStr))) == null) {
            throw new JsonParseException("Invalid or unsupported resource type: " + type);
        }
        return serializer.read(id, json);
    }

    public T deserialize(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        IReloadableResourceSerializer<T> serializer = this.serializers.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown serializer type " + type);
        }
        return serializer.read(id, buffer);
    }

    public void serialize(PacketBuffer buffer, T obj) {
        buffer.func_192572_a(obj.getId());
        IReloadableResourceSerializer<T> serializer = obj.getSerializer();
        buffer.func_192572_a(serializer.getSerializerName());
        serializer.write(buffer, obj);
    }

    @Nullable
    public T get(ResourceLocation id) {
        return (T)((IReloadableResource)this.resources.get(id));
    }

    public Collection<T> getValues() {
        return this.resources.values();
    }

    protected Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    protected Collection<ResourceLocation> getAllResources(IResourceManager resourceManager) {
        return resourceManager.func_199003_a(this.dataPath, s -> s.endsWith(".json"));
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        Gson gson = this.getGson();
        Collection<ResourceLocation> resourceLocations = this.getAllResources(resourceManager);
        if (resourceLocations.isEmpty()) {
            return;
        }
        this.resources.clear();
        for (ResourceLocation id : resourceLocations) {
            try {
                IResource iResource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    int substringStart = this.dataPath.length();
                    int substringEnd = id.func_110623_a().length() - ".json".length();
                    String path = id.func_110623_a().substring(substringStart, substringEnd);
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    this.logger.debug(this.logMarker, "Found resource file '{}', reading as '{}'", (Object)id, (Object)name);
                    JsonObject json = (JsonObject)JsonUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iResource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (json == null) {
                        this.logger.error(this.logMarker, "Could not load resource '{}' as it's null or empty", (Object)name);
                        continue;
                    }
                    T obj = this.deserialize(name, json);
                    this.addObject(name, obj);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iResource == null) continue;
                    if (throwable != null) {
                        try {
                            iResource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iResource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                this.logger.error(this.logMarker, "Parsing error loading '{}'", (Object)id);
                this.logger.catching(ex);
            }
            catch (IOException ex) {
                this.logger.error(this.logMarker, "Could not read file '{}'", (Object)id);
                this.logger.catching((Throwable)ex);
            }
        }
        this.logger.info(this.logMarker, "Registered {} objects", (Object)this.resources.size());
    }

    protected void addObject(ResourceLocation id, T obj) {
        if (this.resources.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate object with ID " + id);
        }
        this.resources.put(id, obj);
    }

    protected abstract SimpleChannel getModChannel();

    protected abstract SyncResourcesPacket<T> getSyncPacket();

    private void sendResourcesToClient(EntityPlayerMP player) {
        Collection<T> objects = this.getValues();
        this.logger.info(this.logMarker, "Sending {} objects to {}", (Object)objects.size(), (Object)player.func_195047_I_());
        SyncResourcesPacket<T> packet = this.getSyncPacket();
        this.getModChannel().sendTo(packet, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void onSyncPacket(SyncResourcesPacket<T> packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            this.resources.clear();
            packet.getResources().forEach(t -> this.resources.put(t.getId(), t));
            this.logger.info("Read {} objects from server", (Object)this.resources.size());
        });
        context.get().setPacketHandled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        this.sendResourcesToClient(playerMP);
    }
}

