/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.silentchaos512.utils.Anchor;

public abstract class DebugRenderOverlay
extends AbstractGui {
    protected static final String SPLITTER = "=";
    private static final int DEFAULT_UPDATE_FREQUENCY = 10;
    private static final int DEFAULT_SPLIT_WIDTH = 100;
    private static final int LINE_HEIGHT = 10;
    private List<String> debugText = new ArrayList<String>();
    private int textWidth;
    private int textHeight;
    @Deprecated
    private int startX = 3;
    @Deprecated
    private int startY = 3;
    private int ticksPassed = 0;

    protected DebugRenderOverlay() {
        MinecraftForge.EVENT_BUS.addListener(this::renderTick);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Deprecated
    protected DebugRenderOverlay(int startX, int startY) {
        this();
        this.startX = startX;
        this.startY = startY;
    }

    @Nonnull
    public abstract List<String> getDebugText();

    public abstract float getTextScale();

    public Anchor getAnchorPoint() {
        return Anchor.TOP_LEFT;
    }

    public int getMarginSize() {
        return 3;
    }

    @Nonnegative
    public int getUpdateFrequency() {
        return 10;
    }

    @Nonnegative
    public int getSplitWidth() {
        return 100;
    }

    public abstract boolean isHidden();

    protected void drawLine(FontRenderer font, String line, int x, int y, int color) {
        String[] array = line.split(SPLITTER);
        if (array.length == 2) {
            font.func_175063_a(array[0].trim(), (float)x, (float)y, color);
            font.func_175063_a(array[1].trim(), (float)(x + this.getSplitWidth()), (float)y, color);
        } else {
            font.func_175063_a(line, (float)x, (float)y, color);
        }
    }

    @Deprecated
    public int getStartX() {
        return this.startX;
    }

    @Deprecated
    public int getStartY() {
        return this.startY;
    }

    public void renderTick(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isHidden() || this.debugText.isEmpty() || mc.func_147113_T() || mc.field_71474_y.field_74330_P || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        float scale = this.getTextScale();
        if (scale <= 0.0f) {
            return;
        }
        FontRenderer font = mc.field_71466_p;
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        int x = (int)((float)this.getAnchorPoint().getX(mc.field_195558_d.func_198107_o(), this.textWidth, this.getMarginSize()) / this.getTextScale());
        int y = (int)((float)this.getAnchorPoint().getY(mc.field_195558_d.func_198087_p(), this.textHeight, this.getMarginSize()) / this.getTextScale());
        for (String line : this.debugText) {
            this.drawLine(font, line, x, y, 0xFFFFFF);
            y += 10;
        }
        GlStateManager.popMatrix();
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.getUpdateFrequency() == 0 || ++this.ticksPassed % this.getUpdateFrequency() == 0) {
            this.debugText = this.getDebugText();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            this.textWidth = 0;
            this.textHeight = 10 * this.debugText.size();
            for (String line : this.debugText) {
                String[] array = line.split(SPLITTER);
                if (array.length == 2) {
                    int width = this.getSplitWidth() + font.func_78256_a(array[1]);
                    this.textWidth = Math.max(this.textWidth, width);
                    continue;
                }
                this.textWidth = Math.max(this.textWidth, font.func_78256_a(line));
            }
        }
    }
}

