/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import alexndr.plugins.SimpleOres.Content;
import alexndr.plugins.SimpleOres.Recipes;
import alexndr.plugins.SimpleOres.Settings;
import alexndr.plugins.SimpleOres.SimpleOres;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ProxyCommon {
    public void preInit(FMLPreInitializationEvent event) {
        ContentRegistry.registerPlugin((Plugin)SimpleOres.plugin);
        SimpleCoreAPI.tabPreInit();
        Settings.createOrLoadSettings(event);
        Content.preInitialize();
        Recipes.preInitialize();
    }

    public void load(FMLInitializationEvent event) {
        Recipes.initialize();
        ProxyCommon.setTabIcons();
        Content.setRepairMaterials();
        Content.setAchievementTriggers();
        ProxyCommon.setOreGenSettings();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void setTabIcons() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting tab icons");
        ArrayList list = Lists.newArrayList((Object[])new Item[]{Item.func_150898_a((Block)Content.copper_ore), Item.func_150898_a((Block)Content.adamantium_block), Content.mythril_ingot, Content.onyx_pickaxe, Content.copper_sword, Item.func_150898_a((Block)Blocks.field_150460_al)});
        SimpleCoreAPI.setTabIcons((List)list);
    }

    private static void setOreGenSettings() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting ore gen parameters");
        OreGenerator.registerOreForGen((int)0, (Block)Content.copper_ore, (Block)Blocks.field_150348_b, (int)Settings.copperOre.getSpawnRate(), (int)Settings.copperOre.getVeinSize(), (int)Settings.copperOre.getMinHeight(), (int)Settings.copperOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.tin_ore, (Block)Blocks.field_150348_b, (int)Settings.tinOre.getSpawnRate(), (int)Settings.tinOre.getVeinSize(), (int)Settings.tinOre.getMinHeight(), (int)Settings.tinOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.mythril_ore, (Block)Blocks.field_150348_b, (int)Settings.mythrilOre.getSpawnRate(), (int)Settings.mythrilOre.getVeinSize(), (int)Settings.mythrilOre.getMinHeight(), (int)Settings.mythrilOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.adamantium_ore, (Block)Blocks.field_150348_b, (int)Settings.adamantiumOre.getSpawnRate(), (int)Settings.adamantiumOre.getVeinSize(), (int)Settings.adamantiumOre.getMinHeight(), (int)Settings.adamantiumOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)-1, (Block)Content.onyx_ore, (Block)Blocks.field_150424_aL, (int)Settings.onyxOre.getSpawnRate(), (int)Settings.onyxOre.getVeinSize(), (int)Settings.onyxOre.getMinHeight(), (int)Settings.onyxOre.getMaxHeight());
    }
}

