/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.config.ConfigHelper;
import alexndr.api.config.types.ConfigArmor;
import alexndr.api.config.types.ConfigBlock;
import alexndr.api.config.types.ConfigBow;
import alexndr.api.config.types.ConfigItem;
import alexndr.api.config.types.ConfigOre;
import alexndr.api.config.types.ConfigTool;
import alexndr.api.logger.LogHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Settings {
    private static Configuration settings;
    public static ConfigBlock copperBlock;
    public static ConfigBlock tinBlock;
    public static ConfigBlock mythrilBlock;
    public static ConfigBlock adamantiumBlock;
    public static ConfigBlock onyxBlock;
    public static ConfigOre copperOre;
    public static ConfigOre tinOre;
    public static ConfigOre mythrilOre;
    public static ConfigOre adamantiumOre;
    public static ConfigOre onyxOre;
    public static ConfigItem copperIngot;
    public static ConfigItem tinIngot;
    public static ConfigItem mythrilIngot;
    public static ConfigItem adamantiumIngot;
    public static ConfigItem onyxGem;
    public static ConfigItem mythrilRod;
    public static ConfigItem onyxRod;
    public static ConfigItem copperBucket;
    public static ConfigTool copperTools;
    public static ConfigTool tinTools;
    public static ConfigTool mythrilTools;
    public static ConfigTool adamantiumTools;
    public static ConfigTool onyxTools;
    public static ConfigArmor copperArmor;
    public static ConfigArmor tinArmor;
    public static ConfigArmor mythrilArmor;
    public static ConfigArmor adamantiumArmor;
    public static ConfigArmor onyxArmor;
    public static ConfigBow mythrilBow;
    public static ConfigBow onyxBow;

    public static void createOrLoadSettings(FMLPreInitializationEvent event) {
        settings = ConfigHelper.GetConfig((FMLPreInitializationEvent)event, (String)"AleXndr", (String)"simpleores.cfg");
        LogHelper.verbose((String)"simpleores", (String)"loading settings...");
        try {
            settings.load();
            ConfigHelper.createHelpEntry((Configuration)settings, (String)"http://minecraft.curseforge.com/projects/simpleores");
            Settings.configureBlocks();
            Settings.configureOres();
            Settings.configureItems();
            Settings.configureTools();
            Settings.configureBows();
            Settings.configureArmor();
        }
        catch (Exception e) {
            LogHelper.severe((String)"simpleores", (String)"Failed to load settings");
            e.printStackTrace();
        }
        finally {
            if (settings.hasChanged()) {
                settings.save();
            }
            LogHelper.verbose((String)"simpleores", (String)"Settings loaded successfully");
        }
    }

    public static void configureItems() {
        copperIngot = new ConfigItem("Copper Ingot", "Items").setSmeltingXP(0.4f);
        copperIngot.GetConfig(settings);
        tinIngot = new ConfigItem("Tin Ingot", "Items").setSmeltingXP(0.4f);
        tinIngot.GetConfig(settings);
        mythrilIngot = new ConfigItem("Mythril Ingot", "Items").setSmeltingXP(0.7f);
        mythrilIngot.GetConfig(settings);
        adamantiumIngot = new ConfigItem("Adamantium Ingot", "Items").setSmeltingXP(0.7f);
        adamantiumIngot.GetConfig(settings);
        onyxGem = new ConfigItem("Onyx Gem", "Items").setSmeltingXP(1.0f);
        onyxGem.GetConfig(settings);
        mythrilRod = new ConfigItem("Mythril Rod", "Items");
        mythrilRod.GetConfig(settings);
        onyxRod = new ConfigItem("Onyx Rod", "Items");
        onyxRod.GetConfig(settings);
        copperBucket = new ConfigItem("Copper Bucket", "Items");
        copperBucket.GetConfig(settings);
    }

    public static void configureTools() {
        copperTools = new ConfigTool("Copper Tools").setUses(185).setHarvestLevel(1).setHarvestSpeed(4.0f).setDamageVsEntity(1.0f).setEnchantability(8);
        copperTools.GetConfig(settings);
        tinTools = new ConfigTool("Tin Tools").setUses(220).setHarvestLevel(1).setHarvestSpeed(3.5f).setDamageVsEntity(1.0f).setEnchantability(8);
        tinTools.GetConfig(settings);
        mythrilTools = new ConfigTool("Mythril Tools").setUses(800).setHarvestLevel(2).setHarvestSpeed(8.0f).setDamageVsEntity(3.0f).setEnchantability(12);
        mythrilTools.GetConfig(settings);
        adamantiumTools = new ConfigTool("Adamantium Tools").setUses(1150).setHarvestLevel(2).setHarvestSpeed(14.0f).setDamageVsEntity(3.0f).setEnchantability(3);
        adamantiumTools.GetConfig(settings);
        onyxTools = new ConfigTool("Onyx Tools").setUses(3280).setHarvestLevel(4).setHarvestSpeed(10.0f).setDamageVsEntity(5.0f).setEnchantability(15);
        onyxTools.GetConfig(settings);
    }

    public static void configureBows() {
        mythrilBow = new ConfigBow("Mythril Bow");
        mythrilBow.setHasDamageModifier(true).setHasEfficiencyChance(true).setDamageModifier(1.5f).setEfficiencyChance(50).setZoomAmount(0.165f);
        mythrilBow.GetConfig(settings);
        onyxBow = new ConfigBow("Onyx Bow");
        onyxBow.setHasDamageModifier(true).setDamageModifier(1.5f).setZoomAmount(0.165f);
        onyxBow.GetConfig(settings);
    }

    public static void configureArmor() {
        copperArmor = new ConfigArmor("Copper Armor").setDurability(8).setEnchantability(8).setHelmReduction(2).setChestReduction(3).setLegsReduction(2).setBootsReduction(1);
        copperArmor.GetConfig(settings);
        tinArmor = new ConfigArmor("Tin Armor").setDurability(8).setEnchantability(8).setHelmReduction(2).setChestReduction(3).setLegsReduction(2).setBootsReduction(1);
        tinArmor.GetConfig(settings);
        mythrilArmor = new ConfigArmor("Mythril Armor").setDurability(22).setEnchantability(12).setHelmReduction(3).setChestReduction(5).setLegsReduction(4).setBootsReduction(3);
        mythrilArmor.GetConfig(settings);
        adamantiumArmor = new ConfigArmor("Adamantium Armor").setDurability(28).setEnchantability(3).setHelmReduction(3).setChestReduction(8).setLegsReduction(6).setBootsReduction(2);
        adamantiumArmor.GetConfig(settings);
        onyxArmor = new ConfigArmor("Onyx Armor").setDurability(45).setEnchantability(15).setHelmReduction(5).setChestReduction(8).setLegsReduction(6).setBootsReduction(5);
        onyxArmor.GetConfig(settings);
    }

    public static void configureBlocks() {
        copperBlock = new ConfigBlock("Block of Copper", "Blocks").setHardness(7.0f).setResistance(12.0f).setHarvestLevel(0).setHarvestTool("pickaxe").setBeaconBase(true);
        copperBlock.GetConfig(settings);
        tinBlock = new ConfigBlock("Block of Tin", "Blocks").setHardness(7.0f).setResistance(12.0f).setHarvestLevel(0).setHarvestTool("pickaxe").setBeaconBase(true);
        tinBlock.GetConfig(settings);
        mythrilBlock = new ConfigBlock("Block of Mythril", "Blocks").setHardness(7.0f).setResistance(12.0f).setHarvestLevel(0).setHarvestTool("pickaxe").setBeaconBase(true);
        mythrilBlock.GetConfig(settings);
        adamantiumBlock = new ConfigBlock("Block of Adamantium", "Blocks").setHardness(7.0f).setResistance(12.0f).setHarvestLevel(0).setHarvestTool("pickaxe").setBeaconBase(true);
        adamantiumBlock.GetConfig(settings);
        onyxBlock = new ConfigBlock("Block of Onyx", "Blocks").setHardness(20.0f).setResistance(30.0f).setHarvestLevel(0).setHarvestTool("pickaxe").setBeaconBase(true);
        onyxBlock.GetConfig(settings);
    }

    public static void configureOres() {
        copperOre = new ConfigOre("Copper Ore").setSpawnRate(35).setVeinSize(10).setMinHeight(1).setMaxHeight(90).setHardness(1.7f).setResistance(5.0f).setHarvestLevel(1).setHarvestTool("pickaxe");
        copperOre.GetConfig(settings);
        tinOre = new ConfigOre("Tin Ore").setHardness(3.0f).setResistance(5.0f).setHarvestLevel(1).setHarvestTool("pickaxe").setSpawnRate(30).setVeinSize(10).setMinHeight(1).setMaxHeight(90);
        tinOre.GetConfig(settings);
        mythrilOre = new ConfigOre("Mythril Ore").setHardness(4.0f).setResistance(5.0f).setHarvestLevel(2).setHarvestTool("pickaxe").setSpawnRate(10).setVeinSize(8).setMinHeight(1).setMaxHeight(40);
        mythrilOre.GetConfig(settings);
        adamantiumOre = new ConfigOre("Adamantium Ore").setHardness(5.0f).setResistance(5.0f).setHarvestLevel(2).setHarvestTool("pickaxe").setSpawnRate(6).setVeinSize(6).setMinHeight(1).setMaxHeight(30);
        adamantiumOre.GetConfig(settings);
        onyxOre = new ConfigOre("Onyx Ore").setHardness(7.0f).setResistance(5.0f).setHarvestLevel(3).setHarvestTool("pickaxe").setSpawnRate(6).setVeinSize(6).setMinHeight(1).setMaxHeight(127);
        onyxOre.GetConfig(settings);
    }
}

