/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simpleores;

import mod.alexndr.simpleores.api.loot.ChestLootHandler;
import mod.alexndr.simpleores.config.SimpleOresConfig;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="simpleores", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"simpleores Forge Event Subscriber");

    @SubscribeEvent
    public static void LootLoad(LootTableLoadEvent event) {
        if (SimpleOresConfig.addModLootToChests) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix)) {
                String file = name.substring(name.indexOf(prefix) + prefix.length());
                if (file.startsWith("village/village_")) {
                    String village = "village/";
                    file = file.substring(file.indexOf(village) + village.length());
                } else if (file.startsWith("stronghold_")) {
                    file = "stronghold";
                }
                switch (file) {
                    case "simple_dungeon": 
                    case "stronghold": 
                    case "woodland_mansion": 
                    case "shipwreck_supply": 
                    case "shipwreck_map": 
                    case "shipwreck_treasure": 
                    case "buried_treasure": 
                    case "pillager_outpost": 
                    case "underwater_ruin_small": 
                    case "underwater_ruin_big": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool("simpleores", "simple_dungeon"));
                        break;
                    }
                    case "nether_bridge": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool("simpleores", "nether"));
                        break;
                    }
                    case "village_weaponsmith": 
                    case "village_toolsmith": 
                    case "village_armorer": 
                    case "village_shepherd": 
                    case "village_mason": 
                    case "village_fletcher": 
                    case "desert_pyramid": 
                    case "abandoned_mineshaft": 
                    case "jungle_temple": 
                    case "spawn_bonus_chest": 
                    case "igloo_chest": {
                        LOGGER.debug("Attempting to inject loot pool for " + file);
                        event.getTable().addPool(ChestLootHandler.getInjectPool("simpleores", file));
                        break;
                    }
                }
            }
        }
    }
}

