/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simpleores.api.config;

import com.google.gson.JsonObject;
import mod.alexndr.simpleores.api.config.ISimpleConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FlagCondition
implements ICondition {
    private final ISimpleConfig config;
    private final ResourceLocation resource;
    private final String name;

    public FlagCondition(ISimpleConfig cfg, String name, ResourceLocation resource) {
        this.config = cfg;
        this.name = name;
        this.resource = resource;
    }

    public ResourceLocation getID() {
        return this.resource;
    }

    public boolean test() {
        return this.config.getFlag(this.name);
    }

    public static class Serializer
    implements IConditionSerializer<FlagCondition> {
        private final ISimpleConfig config;
        private final ResourceLocation resource;

        public Serializer(ISimpleConfig config, ResourceLocation resource) {
            this.config = config;
            this.resource = resource;
        }

        public void write(JsonObject json, FlagCondition value) {
            json.addProperty("flag", value.name);
        }

        public FlagCondition read(JsonObject json) {
            return new FlagCondition(this.config, json.getAsJsonPrimitive("flag").getAsString(), this.resource);
        }

        public ResourceLocation getID() {
            return this.resource;
        }
    }
}

