/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.theoneprobe.ForgeEventHandlers;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.providers.BlockProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DebugProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoEntityProvider;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.providers.EntityProbeInfoEntityProvider;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.playerdata.PlayerGotNote;
import mcjty.theoneprobe.proxy.ClientProxy;
import mcjty.theoneprobe.proxy.IProxy;
import mcjty.theoneprobe.proxy.ServerProxy;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="theoneprobe")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheOneProbe {
    public static final String MODID = "theoneprobe";
    public static final String VERSION = "1.4.30";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final Logger logger = LogManager.getLogger();
    public static File mainConfigDir;
    public static File modConfigDir;
    public static TheOneProbeImp theOneProbeImp;
    public static boolean baubles;
    public static boolean tesla;
    public static boolean redstoneflux;
    public static ItemGroup tabProbe;

    public TheOneProbe() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("theoneprobe-client.toml"));
        Config.loadConfig(Config.SERVER_CONFIG, FMLPaths.CONFIGDIR.get().resolve("theoneprobe-server.toml"));
    }

    private void init(FMLCommonSetupEvent event) {
        tesla = ModList.get().isLoaded("tesla");
        if (tesla) {
            logger.log(Level.INFO, "The One Probe Detected TESLA: enabling support");
        }
        if (redstoneflux = ModList.get().isLoaded("redstoneflux")) {
            logger.log(Level.INFO, "The One Probe Detected RedstoneFlux: enabling support");
        }
        if (baubles = ModList.get().isLoaded("baubles")) {
            if (((Boolean)Config.supportBaubles.get()).booleanValue()) {
                logger.log(Level.INFO, "The One Probe Detected Baubles: enabling support");
            } else {
                logger.log(Level.INFO, "The One Probe Detected Baubles but support disabled in config");
                baubles = false;
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        TheOneProbe.registerCapabilities();
        TheOneProbeImp.registerElements();
        theOneProbeImp.registerProvider(new DefaultProbeInfoProvider());
        theOneProbeImp.registerProvider(new DebugProbeInfoProvider());
        theOneProbeImp.registerProvider(new BlockProbeInfoProvider());
        theOneProbeImp.registerEntityProvider(new DefaultProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new DebugProbeInfoEntityProvider());
        theOneProbeImp.registerEntityProvider(new EntityProbeInfoEntityProvider());
        PacketHandler.registerMessages(MODID);
        this.configureProviders();
        this.configureEntityProviders();
        proxy.setup(event);
    }

    private void initClient(FMLClientSetupEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTheOneProbe".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(theOneProbeImp);
            }
        });
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.init();
        event.getRegistry().register((IForgeRegistryEntry)ModItems.probe);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.creativeProbe);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.diamondHelmetProbe);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.goldHelmetProbe);
        event.getRegistry().register((IForgeRegistryEntry)ModItems.ironHelmetProbe);
        if (baubles) {
            event.getRegistry().register((IForgeRegistryEntry)ModItems.probeGoggles);
        }
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PlayerGotNote.class, (Capability.IStorage)new Capability.IStorage<PlayerGotNote>(){

            public void readNBT(Capability<PlayerGotNote> capability, PlayerGotNote instance, EnumFacing side, INBTBase nbt) {
                throw new UnsupportedOperationException();
            }

            public INBTBase writeNBT(Capability<PlayerGotNote> capability, PlayerGotNote instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    private void configureProviders() {
        List<IProbeInfoProvider> providers = theOneProbeImp.getProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] sortedProviders = defaultValues;
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureProviders(sortedProviders, excluded);
    }

    private void configureEntityProviders() {
        List<IProbeInfoEntityProvider> providers = theOneProbeImp.getEntityProviders();
        String[] defaultValues = new String[providers.size()];
        int i = 0;
        for (IProbeInfoEntityProvider provider : providers) {
            defaultValues[i++] = provider.getID();
        }
        String[] sortedProviders = defaultValues;
        String[] excludedProviders = new String[]{};
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, excludedProviders);
        theOneProbeImp.configureEntityProviders(sortedProviders, excluded);
    }

    static {
        theOneProbeImp = new TheOneProbeImp();
        baubles = false;
        tesla = false;
        redstoneflux = false;
        tabProbe = new ItemGroup("Probe"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.probe);
            }
        };
    }
}

