/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collections;
import mcjty.lib.api.power.IBigPower;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.compat.TeslaTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    @Override
    public String getID() {
        return "theoneprobe:default";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        Block block = blockState.func_177230_c();
        BlockPos pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : TheOneProbe.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, blockState, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, world, pos, player, data);
        }
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState);
        }
        boolean showHarvestLevel = Tools.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Tools.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
        } else if (showHarvestLevel) {
            HarvestInfoTools.showHarvestLevel(probeInfo, blockState, block);
        } else if (showHarvested) {
            HarvestInfoTools.showCanBeHarvested(probeInfo, world, pos, block, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, blockState, data, block);
        }
        ChestInfoTools.showChestInfo(mode, probeInfo, world, pos, config);
        if (config.getRFMode() > 0) {
            this.showRF(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowTankSetting()) && config.getTankMode() > 0) {
            this.showTankInfo(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowBrewStandSetting())) {
            this.showBrewingStandInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, data, block);
        }
    }

    private void showBrewingStandInfo(IProbeInfo probeInfo, World world, IProbeHitData data, Block block) {
        TileEntity te;
        if (block instanceof BlockBrewingStand && (te = world.func_175625_s(data.getPos())) instanceof TileEntityBrewingStand) {
            int brewtime = ((TileEntityBrewingStand)te).func_174887_a_(0);
            int fuel = ((TileEntityBrewingStand)te).func_174887_a_(1);
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack((IItemProvider)Items.field_151065_br), probeInfo.defaultItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.LABEL) + "Fuel: " + (Object)((Object)TextStyleClass.INFO) + fuel);
            if (brewtime > 0) {
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Time: " + (Object)((Object)TextStyleClass.INFO) + brewtime + " ticks");
            }
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, World world, IProbeHitData data, Block block) {
        TileEntity te;
        if (block instanceof BlockMobSpawner && (te = world.func_175625_s(data.getPos())) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic logic = ((TileEntityMobSpawner)te).func_145881_a();
            String mobName = logic.func_184994_d().func_145748_c_().func_150254_d();
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Object)((Object)TextStyleClass.LABEL) + "Mob: " + (Object)((Object)TextStyleClass.INFO) + mobName);
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, World world, IBlockState blockState, IProbeHitData data, Block block, boolean showLever) {
        if (showLever && block instanceof BlockLever) {
            return;
        }
        int redstonePower = block instanceof BlockRedstoneWire ? ((Integer)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : world.func_175651_c(data.getPos(), data.getSideHit().func_176734_d());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new ItemStack((IItemProvider)Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "Power: " + (Object)((Object)TextStyleClass.INFO) + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, World world, IBlockState blockState, IProbeHitData data, Block block) {
        if (block instanceof BlockLever) {
            Boolean powered = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
            probeInfo.horizontal().item(new ItemStack((IItemProvider)Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text((Object)((Object)TextStyleClass.LABEL) + "State: " + (Object)((Object)TextStyleClass.INFO) + (powered != false ? "On" : "Off"));
        } else if (block instanceof BlockRedstoneComparator) {
            ComparatorMode mode = (ComparatorMode)blockState.func_177229_b((IProperty)BlockRedstoneComparator.field_176463_b);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Mode: " + (Object)((Object)TextStyleClass.INFO) + mode.func_176610_l());
        } else if (block instanceof BlockRedstoneRepeater) {
            Boolean locked = (Boolean)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_176411_a);
            Integer delay = (Integer)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_176410_b);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Delay: " + (Object)((Object)TextStyleClass.INFO) + delay + " ticks");
            if (locked.booleanValue()) {
                probeInfo.text((Object)((Object)TextStyleClass.INFO) + "Locked");
            }
        }
    }

    private void showTankInfo(IProbeInfo probeInfo, World world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                IFluidTankProperties[] properties = handler.getTankProperties();
                if (properties != null) {
                    for (IFluidTankProperties property : properties) {
                        if (property == null) continue;
                        FluidStack fluidStack = property.getContents();
                        int maxContents = property.getCapacity();
                        this.addFluidInfo(probeInfo, config, fluidStack, maxContents);
                    }
                }
            });
        }
    }

    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
        int contents;
        int n = contents = fluidStack == null ? 0 : fluidStack.amount;
        if (fluidStack != null) {
            probeInfo.text((Object)((Object)TextStyleClass.NAME) + "Liquid: " + fluidStack.getLocalizedName());
        }
        if (config.getTankMode() == 1) {
            probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat.get()));
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.PROGRESS) + ElementProgress.format(contents, Config.tankFormat.get(), "mB"));
        }
    }

    private void showRF(IProbeInfo probeInfo, World world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        TileEntity te = world.func_175625_s(pos);
        if (TheOneProbe.tesla && TeslaTools.isEnergyHandler(te)) {
            long energy = TeslaTools.getEnergy(te);
            long maxEnergy = TeslaTools.getMaxEnergy(te);
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (te instanceof IBigPower) {
            long energy = ((IBigPower)te).getStoredPower();
            long maxEnergy = ((IBigPower)te).getCapacity();
            this.addRFInfo(probeInfo, config, energy, maxEnergy);
        } else if (te != null && te.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            te.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> this.addRFInfo(probeInfo, config, handler.getEnergyStored(), handler.getMaxEnergyStored()));
        }
    }

    private void addRFInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat.get()));
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.PROGRESS) + "RF: " + ElementProgress.format(energy, Config.rfFormat.get(), "RF"));
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, IBlockState blockState) {
        for (IProperty property : blockState.func_206869_a()) {
            if (!"age".equals(property.func_177701_a())) continue;
            if (property.func_177699_b() == Integer.class) {
                int maxAge;
                IProperty integerProperty = property;
                int age = (Integer)blockState.func_177229_b(integerProperty);
                if (age == (maxAge = ((Integer)Collections.max(integerProperty.func_177700_c())).intValue())) {
                    probeInfo.text((Object)((Object)TextStyleClass.OK) + "Fully grown");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Growth: " + (Object)((Object)TextStyleClass.WARNING) + age * 100 / maxAge + "%");
                }
            }
            return;
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, IBlockState blockState, Block block, World world, BlockPos pos, EntityPlayer player, IProbeHitData data) {
        String modid = Tools.getModName(block);
        ItemStack pickBlock = data.getPickBlock();
        if (block instanceof BlockSilverfish && mode != ProbeMode.DEBUG && !Tools.show(mode, config.getShowSilverfish())) {
            block = ((BlockSilverfish)block).func_196468_d();
            pickBlock = new ItemStack((IItemProvider)block, 1);
        }
        if (!pickBlock.func_190926_b()) {
            if (Tools.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text((Object)((Object)TextStyleClass.MODNAME) + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text((Object)((Object)TextStyleClass.NAME) + DefaultProbeInfoProvider.getBlockUnlocalizedName(block)).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.vertical().text((Object)((Object)TextStyleClass.NAME) + DefaultProbeInfoProvider.getBlockUnlocalizedName(block));
        }
    }

    private static String getBlockUnlocalizedName(Block block) {
        return "{*" + block.func_149739_a() + ".name" + "*}";
    }
}

