/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class HarvestInfoTools {
    private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");
    private static String[] harvestLevels = new String[]{"stone", "iron", "diamond", "obsidian", "cobalt"};
    private static final HashMap<ToolType, ItemStack> testTools = new HashMap();

    static void showHarvestLevel(IProbeInfo probeInfo, BlockState blockState, Block block) {
        ToolType harvestTool = block.getHarvestTool(blockState);
        if (harvestTool != null) {
            int harvestLevel = block.getHarvestLevel(blockState);
            String harvestName = harvestLevel >= harvestLevels.length ? Integer.toString(harvestLevel) : (harvestLevel < 0 ? Integer.toString(harvestLevel) : harvestLevels[harvestLevel]);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tool: " + (Object)((Object)TextStyleClass.INFO) + harvestTool + " (level " + harvestName + ")");
        }
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, World world, BlockPos pos, Block block, PlayerEntity player) {
        boolean harvestable;
        if (ModItems.isProbeInHand(player.func_184614_ca())) {
            return;
        }
        boolean bl = harvestable = block.canHarvestBlock(world.func_180495_p(pos), (IBlockReader)world, pos, player) && world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        if (harvestable) {
            probeInfo.text((Object)((Object)TextStyleClass.OK) + "Harvestable");
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Not harvestable");
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, World world, BlockPos pos, Block block, BlockState blockState, PlayerEntity player) {
        boolean v;
        int harvestLevel;
        float blockHardness;
        boolean harvestable = block.canHarvestBlock(world.func_180495_p(pos), (IBlockReader)world, pos, player) && world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        ToolType harvestTool = block.getHarvestTool(blockState);
        String harvestName = null;
        if (harvestTool == null && (blockHardness = blockState.func_185887_b((IBlockReader)world, pos)) > 0.0f) {
            for (Map.Entry<ToolType, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ToolItem)) continue;
                ToolItem toolItem = (ToolItem)testTool.func_77973_b();
                if (!(testTool.func_150997_a(blockState) >= toolItem.func_200891_e().func_200928_b())) continue;
                harvestTool = testToolEntry.getKey();
                break;
            }
        }
        if (harvestTool != null && (harvestLevel = block.getHarvestLevel(blockState)) >= 0 && harvestLevel < harvestLevels.length) {
            harvestName = harvestLevels[harvestLevel];
        }
        int offs = (v = ((Boolean)Config.harvestStyleVanilla.get()).booleanValue()) ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.OK) + (harvestTool != null ? harvestTool.getName() : "No tool"));
        } else if (harvestName == null || harvestName.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool.getName() : "No tool"));
        } else {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool.getName() : "No tool") + " (level " + harvestName + ")");
        }
    }

    static {
        testTools.put(ToolType.SHOVEL, new ItemStack((IItemProvider)Items.field_151038_n));
        testTools.put(ToolType.AXE, new ItemStack((IItemProvider)Items.field_151053_p));
        testTools.put(ToolType.PICKAXE, new ItemStack((IItemProvider)Items.field_151039_o));
    }
}

