/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetEntityInfo {
    private int dim;
    private UUID uuid;
    private ProbeMode mode;
    private Vec3d hitVec;

    public PacketGetEntityInfo(ByteBuf buf) {
        this.dim = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.mode = ProbeMode.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeByte(this.mode.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_72450_a);
            buf.writeDouble(this.hitVec.field_72448_b);
            buf.writeDouble(this.hitVec.field_72449_c);
        }
    }

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, RayTraceResult mouseOver, Entity entity) {
        this.dim = dim;
        this.uuid = entity.func_110124_au();
        this.mode = mode;
        this.hitVec = mouseOver.func_216347_e();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            DimensionType type = DimensionType.func_186069_a((int)this.dim);
            ServerWorld world = DimensionManager.getWorld((MinecraftServer)((NetworkEvent.Context)ctx.get()).getSender().field_71133_b, (DimensionType)type, (boolean)true, (boolean)false);
            if (world != null && (entity = world.func_217461_a(this.uuid)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.mode, (World)world, entity, this.hitVec);
                PacketHandler.INSTANCE.sendTo((Object)new PacketReturnEntityInfo(this.uuid, probeInfo), ((NetworkEvent.Context)ctx.get()).getSender().field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static ProbeInfo getProbeInfo(PlayerEntity player, ProbeMode mode, World world, Entity entity, Vec3d hitVec) {
        if ((Integer)Config.needsProbe.get() == 3) {
            if (!ModItems.hasAProbeSomewhere(player) && mode == ProbeMode.EXTENDED) {
                mode = ProbeMode.NORMAL;
            }
        } else if ((Integer)Config.needsProbe.get() == 2 && !ModItems.hasAProbeSomewhere(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = TheOneProbe.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Error: " + (Object)((Object)TextStyleClass.ERROR) + provider.getID());
            }
        }
        return probeInfo;
    }
}

