/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.api;

import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CompoundText {
    private ITextComponent component = null;

    public static CompoundText create() {
        return new CompoundText();
    }

    public CompoundText style(TextStyleClass style) {
        StringTextComponent cmp = new StringTextComponent(style.toString());
        return this.newComponent((ITextComponent)cmp);
    }

    public CompoundText text(ITextComponent cmp) {
        return this.newComponent(cmp);
    }

    public CompoundText text(String text) {
        return this.newComponent((ITextComponent)new StringTextComponent(text));
    }

    public CompoundText info(String translationKey) {
        return this.style(TextStyleClass.INFO).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText important(String translationKey) {
        return this.style(TextStyleClass.INFOIMP).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText warning(String translationKey) {
        return this.style(TextStyleClass.WARNING).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText error(String translationKey) {
        return this.style(TextStyleClass.ERROR).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText label(String translationKey) {
        return this.style(TextStyleClass.LABEL).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText ok(String translationKey) {
        return this.style(TextStyleClass.OK).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText name(String translationKey) {
        return this.style(TextStyleClass.NAME).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    public CompoundText progress(String translationKey) {
        return this.style(TextStyleClass.PROGRESS).text((ITextComponent)new TranslationTextComponent(translationKey, new Object[0]));
    }

    private CompoundText newComponent(ITextComponent cmp) {
        if (this.component == null) {
            this.component = cmp;
        } else {
            this.component.func_150257_a(cmp);
        }
        return this;
    }

    public ITextComponent get() {
        return this.component;
    }
}

