/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.File;
import mcjty.lib.compat.CompatCreativeTabs;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.proxy.CommonProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="theoneprobe", name="TheOneProbe", dependencies="required-after:compatlayer@[0.1.6,);after:Forge@[12.18.1.2082,);after:forge@[13.19.0.2176,);after:tesla", version="1.4.19", guiFactory="mcjty.theoneprobe.config.TopModGuiFactory", acceptedMinecraftVersions="[1.10,1.12)")
public class TheOneProbe {
    public static final String MODID = "theoneprobe";
    public static final String VERSION = "1.4.19";
    public static final String MIN_FORGE10_VER = "12.18.1.2082";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    public static final String COMPATLAYER_VER = "0.1.6";
    @SidedProxy(clientSide="mcjty.theoneprobe.proxy.ClientProxy", serverSide="mcjty.theoneprobe.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static TheOneProbe instance;
    public static Logger logger;
    public static File mainConfigDir;
    public static File modConfigDir;
    public static Configuration config;
    public static TheOneProbeImp theOneProbeImp;
    public static boolean baubles;
    public static CreativeTabs tabProbe;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        mainConfigDir = e.getModConfigurationDirectory();
        modConfigDir = new File(mainConfigDir.getPath());
        config = new Configuration(new File(modConfigDir, "theoneprobe.cfg"));
        boolean bl = baubles = Loader.isModLoaded((String)"Baubles") || Loader.isModLoaded((String)"baubles");
        if (baubles) {
            if (Config.supportBaubles) {
                logger.log(Level.INFO, "The One Probe Detected Baubles: enabling support");
            } else {
                logger.log(Level.INFO, "The One Probe Detected Baubles but support disabled in config");
                baubles = false;
            }
        }
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equalsIgnoreCase("getTheOneProbe")) continue;
            Optional value = message.getFunctionValue(ITheOneProbe.class, Void.class);
            if (value.isPresent()) {
                ((Function)value.get()).apply((Object)theOneProbeImp);
                continue;
            }
            logger.warn("Some mod didn't return a valid result with getTheOneProbe!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    static {
        theOneProbeImp = new TheOneProbeImp();
        baubles = false;
        tabProbe = new CompatCreativeTabs("Probe"){

            protected Item getItem() {
                return ModItems.probe;
            }
        };
    }
}

