/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.tools.ItemStackTools;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChestInfoTools {
    static void showChestInfo(ProbeMode mode, IProbeInfo probeInfo, World world, BlockPos pos, IProbeConfig config) {
        ArrayList<ItemStack> stacks = null;
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || Config.showSmallChestContentsWithoutSneaking <= 0 && Config.getInventoriesToShow().isEmpty())) {
            int slots;
            if (Config.getInventoriesToShow().contains(world.func_180495_p(pos).func_177230_c().getRegistryName())) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if (Config.showSmallChestContentsWithoutSneaking > 0 && (slots = ChestInfoTools.getChestContents(world, pos, stacks = new ArrayList())) <= Config.showSmallChestContentsWithoutSneaking) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !Config.getInventoriesToNotShow().isEmpty() && Config.getInventoriesToNotShow().contains(world.func_180495_p(pos).func_177230_c().getRegistryName())) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Tools.show(mode, chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<ItemStack>();
                ChestInfoTools.getChestContents(world, pos, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Tools.show(mode, config.getShowChestContentsDetailed()) && stacks.size() <= Config.showItemDetailThresshold;
                ChestInfoTools.showChestContents(probeInfo, world, pos, stacks, showDetailed);
            }
        }
    }

    private static void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, @Nonnull ItemStack stack) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                ItemStackTools.incStackSize((ItemStack)s, (int)ItemStackTools.getStackSize((ItemStack)stack));
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        if (foundItems != null) {
            foundItems.add(stack.func_77973_b());
        }
    }

    private static void showChestContents(IProbeInfo probeInfo, World world, BlockPos pos, List<ItemStack> stacks, boolean detailed) {
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        int rows = 0;
        int idx = 0;
        vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Config.chestContentsBorderColor).spacing(0));
        if (detailed) {
            for (ItemStack stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text((Object)((Object)TextStyleClass.INFO) + stackInSlot.func_82833_r());
            }
        } else {
            for (ItemStack stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getChestContents(World world, BlockPos pos, List<ItemStack> stacks) {
        int maxSlots;
        block3: {
            HashSet<Item> foundItems;
            TileEntity te;
            block2: {
                te = world.func_175625_s(pos);
                foundItems = Config.compactEqualStacks ? new HashSet<Item>() : null;
                maxSlots = 0;
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) break block2;
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                maxSlots = capability.getSlots();
                for (int i = 0; i < maxSlots; ++i) {
                    ChestInfoTools.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
                }
                break block3;
            }
            if (!(te instanceof IInventory)) break block3;
            IInventory inventory = (IInventory)te;
            maxSlots = inventory.func_70302_i_();
            for (int i = 0; i < maxSlots; ++i) {
                ChestInfoTools.addItemStack(stacks, foundItems, inventory.func_70301_a(i));
            }
        }
        return maxSlots;
    }
}

