/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collection;
import mcjty.theoneprobe.Config;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        if (entity instanceof EntityLivingBase) {
            Collection effects;
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.func_110143_aJ();
                int maxHealth = (int)livingBase.func_110138_aP();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(TextFormatting.YELLOW + "Health: " + health + " / " + maxHealth);
                }
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.func_70651_bq()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (PotionEffect effect : effects) {
                    String s1 = I18n.func_74838_a((String)effect.func_76453_d()).trim();
                    Potion potion = effect.func_188419_a();
                    if (effect.func_76458_c() > 0) {
                        s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + effect.func_76458_c())).trim();
                    }
                    if (effect.func_76459_b() > 20) {
                        s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)effect, (float)durationFactor) + ")";
                    }
                    if (potion.func_76398_f()) {
                        vertical.text(TextFormatting.RED + s1);
                        continue;
                    }
                    vertical.text(TextFormatting.GREEN + s1);
                }
            }
        }
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text(TextFormatting.WHITE + entity.func_145748_c_().func_150254_d()).text(TextFormatting.BLUE + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text(TextFormatting.WHITE + entity.func_145748_c_().func_150254_d());
        }
    }
}

