/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.theoneprobe.Config;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    private String[] harvestLevels = new String[]{"stone", "iron", "diamond", "obsidian", "cobalt"};

    @Override
    public String getID() {
        return "theoneprobe:default";
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        Block block = blockState.func_177230_c();
        BlockPos pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, world, pos, player, data);
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState, block);
        }
        if (Tools.show(mode, config.getShowHarvestLevel())) {
            this.showHarvestLevel(probeInfo, blockState, block);
        }
        if (Tools.show(mode, config.getShowCanBeHarvested())) {
            this.showCanBeHarvested(probeInfo, world, pos, block, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, blockState, data, block);
        }
        if (Tools.show(mode, config.getShowChestContents())) {
            this.showChestContents(probeInfo, world, pos);
        }
        if (config.getRFMode() > 0) {
            this.showRF(probeInfo, world, pos);
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, World world, IBlockState blockState, IProbeHitData data, Block block, boolean showLever) {
        if (showLever && block instanceof BlockLever) {
            return;
        }
        int redstonePower = block instanceof BlockRedstoneWire ? ((Integer)blockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : world.func_175651_c(data.getPos(), data.getSideHit().func_176734_d());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new ItemStack(Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text("Power: " + redstonePower);
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, World world, IBlockState blockState, IProbeHitData data, Block block) {
        if (block instanceof BlockLever) {
            Boolean powered = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
            probeInfo.horizontal().item(new ItemStack(Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text("State: " + (powered != false ? "On" : "Off"));
        }
    }

    private void showRF(IProbeInfo probeInfo, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyHandler) {
            ProbeConfig config = Config.getDefaultConfig();
            IEnergyHandler handler = (IEnergyHandler)te;
            int energy = handler.getEnergyStored(EnumFacing.DOWN);
            int maxEnergy = handler.getMaxEnergyStored(EnumFacing.DOWN);
            if (config.getRFMode() == 1) {
                probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
            } else {
                probeInfo.text(TextFormatting.GREEN + "RF: " + ElementProgress.format(energy, Config.rfFormat) + "RF");
            }
        }
    }

    private void showHarvestLevel(IProbeInfo probeInfo, IBlockState blockState, Block block) {
        String harvestTool = block.getHarvestTool(blockState);
        if (harvestTool != null) {
            int harvestLevel = block.getHarvestLevel(blockState);
            String harvestName = harvestLevel >= this.harvestLevels.length ? Integer.toString(harvestLevel) : this.harvestLevels[harvestLevel];
            probeInfo.text(TextFormatting.GREEN + "Tool: " + harvestTool + " (level " + harvestName + ")");
        }
    }

    private void showCanBeHarvested(IProbeInfo probeInfo, World world, BlockPos pos, Block block, EntityPlayer player) {
        if (ModItems.isProbe(player.func_184614_ca())) {
            return;
        }
        boolean harvestable = block.canHarvestBlock((IBlockAccess)world, pos, player);
        if (harvestable) {
            probeInfo.text(TextFormatting.GREEN + "Harvestable");
        } else {
            probeInfo.text(TextFormatting.YELLOW + "Not harvestable");
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, IBlockState blockState, Block block) {
        if (block instanceof BlockCrops) {
            BlockCrops crops = (BlockCrops)block;
            int age = crops.func_185527_x(blockState);
            int maxAge = crops.func_185526_g();
            probeInfo.text(TextFormatting.GREEN + "Growth: " + age * 100 / maxAge + "%");
        } else if (block instanceof BlockNetherWart) {
            BlockNetherWart wart = (BlockNetherWart)block;
            int age = (Integer)blockState.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
            int maxAge = 3;
            probeInfo.text(TextFormatting.GREEN + "Growth: " + age * 100 / maxAge + "%");
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, IBlockState blockState, Block block, World world, BlockPos pos, EntityPlayer player, IProbeHitData data) {
        Fluid fluid;
        String modid = Tools.getModName(block);
        if (block instanceof BlockSilverfish && mode != ProbeMode.DEBUG) {
            BlockSilverfish.EnumType type = (BlockSilverfish.EnumType)blockState.func_177229_b((IProperty)BlockSilverfish.field_176378_a);
            blockState = type.func_176883_d();
            block = blockState.func_177230_c();
        }
        if (block instanceof BlockLiquid && (fluid = FluidRegistry.lookupFluidForBlock((Block)block)) != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            probeInfo.horizontal().icon(fluid.getStill(), -1, -1, 16, 16, probeInfo.defaultIconStyle().width(20)).vertical().text(TextFormatting.WHITE + stack.getLocalizedName()).text(TextFormatting.BLUE + modid);
            return;
        }
        ItemStack pickBlock = data.getPickBlock();
        if (pickBlock != null) {
            if (Tools.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().text(TextFormatting.WHITE + pickBlock.func_82833_r()).text(TextFormatting.BLUE + modid);
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).text(TextFormatting.WHITE + pickBlock.func_82833_r());
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text(TextFormatting.WHITE + block.func_149732_F()).text(TextFormatting.BLUE + modid);
        } else {
            probeInfo.vertical().text(TextFormatting.WHITE + block.func_149732_F());
        }
    }

    private void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                s.field_77994_a += stack.field_77994_a;
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        if (foundItems != null) {
            foundItems.add(stack.func_77973_b());
        }
    }

    private void showChestContents(IProbeInfo probeInfo, World world, BlockPos pos) {
        int i;
        TileEntity te = world.func_175625_s(pos);
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        HashSet<Item> foundItems = Config.compactEqualStacks ? new HashSet<Item>() : null;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (i = 0; i < capability.getSlots(); ++i) {
                this.addItemStack(stacks, foundItems, capability.getStackInSlot(i));
            }
        } else if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                this.addItemStack(stacks, foundItems, inventory.func_70301_a(i));
            }
        }
        int rows = 0;
        int idx = 0;
        for (ItemStack stackInSlot : stacks) {
            if (idx % 10 == 0) {
                if (vertical == null) {
                    vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1).spacing(0));
                }
                horizontal = vertical.horizontal(new LayoutStyle().spacing(0));
                if (++rows > 4) break;
            }
            horizontal.item(stackInSlot);
            ++idx;
        }
    }
}

