/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.renderer;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.model.ModelLaserBlade;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class ItemLaserBladeRenderer
extends TileEntityItemStackRenderer {
    public static final Map<ItemCameraTransforms.TransformType, float[]> transformMatrices = new HashMap<ItemCameraTransforms.TransformType, float[]>();
    public static final Map<ItemCameraTransforms.TransformType, float[]> transformMatricesBlockingRight;
    public static final Map<ItemCameraTransforms.TransformType, float[]> transformMatricesBlockingLeft;
    private static final FloatBuffer matrixBuf;

    public void func_192838_a(ItemStack itemStackIn, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        IBakedModel model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(ToLaserBlade.MRL_ITEM_LASER_BLADE);
        if (model instanceof ModelLaserBlade) {
            ModelLaserBlade modelLaserBlade = (ModelLaserBlade)model;
            this.doRender(modelLaserBlade);
        }
    }

    public void doRender(ModelLaserBlade model) {
        float partialTicks = Animation.getPartialTickTime();
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        int colorCore = -1;
        int colorHalo = -65536;
        boolean isSubColorCore = false;
        boolean isSubColorHalo = false;
        NBTTagCompound nbt = model.itemStack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_150297_b("colorC", 3)) {
                colorCore = nbt.func_74762_e("colorC");
            }
            if (nbt.func_150297_b("colorH", 3)) {
                colorHalo = nbt.func_74762_e("colorH");
            }
            if (nbt.func_150297_b("isSubC", 1)) {
                isSubColorCore = nbt.func_74767_n("isSubC");
            }
            if (nbt.func_150297_b("isSubH", 1)) {
                isSubColorHalo = nbt.func_74767_n("isSubH");
            }
        }
        ItemCameraTransforms.TransformType cameraTransformType = model.cameraTransformType;
        boolean isBlocking = ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade && (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) && model.entity != null && model.entity.func_184587_cr();
        this.transform(cameraTransformType, isBlocking);
        boolean isEnableCull = GL11.glIsEnabled((int)2884);
        if (!isEnableCull) {
            GlStateManager.func_179089_o();
        }
        model.renderingMode = ToLaserBladeConfig.client.laserBladeRenderingMode;
        this.renderQuads(renderer, model.getQuadsByName("Hilt"), -1);
        GL11.glPushAttrib((int)64);
        RenderHelper.func_74518_a();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        this.renderQuads(renderer, model.getQuadsByName("Hilt_bright"), -1);
        if (ToLaserBladeConfig.client.laserBladeRenderingMode == 1) {
            if (isSubColorCore) {
                colorCore = ~colorCore | 0xFF000000;
            }
            if (isSubColorHalo) {
                colorHalo = ~colorHalo | 0xFF000000;
            }
            this.renderQuads(renderer, model.getQuadsByName("Blade_halo_2"), colorHalo);
            this.renderQuads(renderer, model.getQuadsByName("Blade_halo_1"), colorHalo);
            this.renderQuads(renderer, model.getQuadsByName("Blade_core"), colorCore);
        } else {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GL14.glBlendEquation((int)32774);
            if (isSubColorCore) {
                GL14.glBlendEquation((int)32779);
            }
            this.renderQuads(renderer, model.getQuadsByName("Blade_core"), colorCore);
            if (!isSubColorCore && isSubColorHalo) {
                GL14.glBlendEquation((int)32779);
            } else if (isSubColorCore && !isSubColorHalo) {
                GL14.glBlendEquation((int)32774);
            }
            this.renderQuads(renderer, model.getQuadsByName("Blade_halo_1"), colorHalo);
            this.renderQuads(renderer, model.getQuadsByName("Blade_halo_2"), colorHalo);
            if (isSubColorHalo) {
                GL14.glBlendEquation((int)32774);
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        if (model.itemStack.func_77962_s()) {
            this.renderEffect(model.getQuadsByName("Hilt"));
            this.renderEffect(model.getQuadsByName("Hilt_bright"));
        }
        if (!isEnableCull) {
            GlStateManager.func_179129_p();
        }
    }

    public void transform(ItemCameraTransforms.TransformType cameraTransformType, boolean isBlocking) {
        matrixBuf.clear();
        float[] matrix = isBlocking ? (Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? transformMatricesBlockingRight.get(cameraTransformType) : transformMatricesBlockingLeft.get(cameraTransformType)) : transformMatrices.get(cameraTransformType);
        if (matrix == null) {
            matrix = transformMatrices.get(ItemCameraTransforms.TransformType.NONE);
        }
        matrixBuf.put(matrix);
        matrixBuf.flip();
        GlStateManager.func_179110_a((FloatBuffer)matrixBuf);
    }

    public void renderEffect(List<BakedQuad> quads) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderQuads(renderer, quads, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderQuads(renderer, quads, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
    }

    public void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad quad : quads) {
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)color);
            Vec3i vec3i = quad.func_178210_d().func_176730_m();
            renderer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    static {
        transformMatrices.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new float[]{-3.090862E-8f, 3.090862E-8f, -1.0f, 0.0f, 0.8838835f, 0.8838835f, 0.0f, 0.0f, 0.70710677f, -0.70710677f, -4.371139E-8f, 0.0f, -0.030330122f, -0.030330122f, 0.5f, 1.0f});
        transformMatrices.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new float[]{-3.090862E-8f, 3.090862E-8f, -1.0f, 0.0f, 0.8838835f, 0.8838835f, 0.0f, 0.0f, 0.70710677f, -0.70710677f, -4.371139E-8f, 0.0f, -0.030330122f, -0.030330122f, 0.5f, 1.0f});
        transformMatrices.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new float[]{-3.244294E-8f, 4.633332E-8f, -1.294f, 0.0f, 0.94637173f, 0.8825059f, 7.871984E-9f, 0.0f, 0.8825059f, -0.94637173f, -5.6012073E-8f, 0.0f, 0.035000555f, 0.030994587f, 0.5f, 1.0f});
        transformMatrices.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new float[]{-3.244294E-8f, 4.633332E-8f, -1.294f, 0.0f, 0.94637173f, 0.8825059f, 7.871984E-9f, 0.0f, 0.8825059f, -0.94637173f, -5.6012073E-8f, 0.0f, 0.035000555f, 0.030994587f, 0.5f, 1.0f});
        transformMatrices.put(ItemCameraTransforms.TransformType.FIXED, new float[]{-5.0862745E-8f, -2.7817755E-8f, -0.9f, 0.0f, 0.63639605f, 0.63639605f, -5.5635514E-8f, 0.0f, 0.63639605f, -0.63639605f, -1.6295264E-8f, 0.0f, 0.022702962f, 0.022702962f, 0.52250004f, 1.0f});
        transformMatrices.put(ItemCameraTransforms.TransformType.NONE, new float[]{-2.7817755E-8f, 2.7817755E-8f, -0.9f, 0.0f, 0.63639605f, 0.63639605f, 0.0f, 0.0f, 0.63639605f, -0.63639605f, -3.934025E-8f, 0.0f, 0.022702962f, 0.022702962f, 0.5f, 1.0f});
        transformMatricesBlockingRight = new HashMap<ItemCameraTransforms.TransformType, float[]>();
        transformMatricesBlockingRight.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new float[]{-0.04950499f, -0.8617275f, -0.50495046f, 0.0f, 0.10771594f, 0.62499994f, -1.0771594f, 0.0f, 0.9950494f, -0.08617279f, 0.049504925f, 0.0f, 0.45283374f, 0.05398178f, 0.6716627f, 1.0f});
        transformMatricesBlockingRight.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new float[]{-0.04950499f, 0.8617275f, -0.50495046f, 0.0f, -0.10771594f, 0.62499994f, 1.0771594f, 0.0f, 0.9950494f, 0.08617279f, 0.049504925f, 0.0f, 0.5471663f, 0.05398178f, 0.3283373f, 1.0f});
        transformMatricesBlockingLeft = new HashMap<ItemCameraTransforms.TransformType, float[]>();
        transformMatricesBlockingLeft.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new float[]{0.049504902f, -0.8617275f, -0.50495046f, 0.0f, -0.10771594f, 0.62499994f, -1.0771594f, 0.0f, 0.9950494f, 0.086172715f, -0.04950497f, 0.0f, 0.5471663f, 0.05398178f, 0.6716627f, 1.0f});
        transformMatricesBlockingLeft.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new float[]{0.049504902f, 0.8617275f, -0.50495046f, 0.0f, 0.10771594f, 0.62499994f, 1.0771594f, 0.0f, 0.9950494f, -0.086172715f, -0.04950497f, 0.0f, 0.45283374f, 0.05398178f, 0.3283373f, 1.0f});
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
    }
}

