/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.entity.LaserTrapEntity;
import com.github.iunius118.tolaserblade.item.ItemLaserBlade;
import com.github.iunius118.tolaserblade.util.LaserTrapPlayer;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class DispenseLaserBladeBehavior
implements IBehaviorDispenseItem {
    public static final Predicate<Entity> LASER_TRAP_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L, Entity::func_70067_L, entity -> ToLaserBladeConfig.common.canLaserTrapAttackPlayer || !(entity instanceof EntityPlayer)});

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        if (!ToLaserBladeConfig.common.isEnabledLaserTrap) {
            return ((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null)).func_82482_a(source, stack);
        }
        World world = source.func_82618_k();
        if (world instanceof WorldServer) {
            BlockPos pos = source.func_180699_d();
            EnumFacing dir = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            LaserTrapPlayer laserTrapPlayer = LaserTrapPlayer.get((WorldServer)world);
            laserTrapPlayer.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            laserTrapPlayer.initInventory(stack.func_77946_l());
            BlockPos targetPos = pos.func_177972_a(dir);
            this.attackEntitiesInPos(laserTrapPlayer, targetPos);
            laserTrapPlayer.func_70106_y();
            int color = ItemLaserBlade.getColorFromNBT(stack, "colorH", "isSubH", ItemLaserBlade.colors[0]);
            LaserTrapEntity laserTrapEntity = new LaserTrapEntity(world, targetPos, dir, color);
            world.func_72838_d((Entity)laserTrapEntity);
        }
        return stack;
    }

    private void attackEntitiesInPos(LaserTrapPlayer laserTrapPlayer, BlockPos pos) {
        AxisAlignedBB boundingBox = new AxisAlignedBB(pos).func_186662_g(0.5);
        List targetEntities = laserTrapPlayer.field_70170_p.func_175674_a(null, boundingBox, LASER_TRAP_TARGETS);
        float attackDamage = (float)laserTrapPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        for (Entity targetEntity : targetEntities) {
            targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)laserTrapPlayer), attackDamage);
        }
    }
}

