/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.model.LaserBladeItemBakedModel;
import com.github.iunius118.tolaserblade.item.LBCasingItem;
import com.github.iunius118.tolaserblade.item.LBEmitterItem;
import com.github.iunius118.tolaserblade.item.LBMediumItem;
import com.github.iunius118.tolaserblade.item.LaserBladeItem;
import com.github.iunius118.tolaserblade.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class ClientEventHandler {
    @SubscribeEvent
    public void onItemColorHandlerEvent(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((IItemColor)new LaserBladeItem.ColorHandler(), new IItemProvider[]{ModItems.LASER_BLADE});
        event.getItemColors().func_199877_a((IItemColor)new LaserBladeItem.ColorHandler(), new IItemProvider[]{ModItems.LB_BROKEN});
        event.getItemColors().func_199877_a((IItemColor)new LBEmitterItem.ColorHandler(), new IItemProvider[]{ModItems.LB_EMITTER});
        event.getItemColors().func_199877_a((IItemColor)new LBMediumItem.ColorHandler(), new IItemProvider[]{ModItems.LB_MEDIUM});
        event.getItemColors().func_199877_a((IItemColor)new LBCasingItem.ColorHandler(), new IItemProvider[]{ModItems.LB_CASING});
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_) && !((Boolean)ToLaserBladeConfig.CLIENT.useInternalModel.get()).booleanValue() && (Integer)ToLaserBladeConfig.CLIENT.externalModelType.get() == 1) {
            event.addSprite(new ResourceLocation("tolaserblade", "item/laser_blade_obj"));
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        if (!((Boolean)ToLaserBladeConfig.CLIENT.useInternalModel.get()).booleanValue() && (Integer)ToLaserBladeConfig.CLIENT.externalModelType.get() != 1) {
            return;
        }
        ModelResourceLocation laserBladeItemID = new ModelResourceLocation(ModItems.LASER_BLADE.getRegistryName(), "inventory");
        ModelResourceLocation lBBrokenItemID = new ModelResourceLocation(ModItems.LB_BROKEN.getRegistryName(), "inventory");
        LaserBladeItemBakedModel bakedModel = new LaserBladeItemBakedModel();
        bakedModel.loadModel(event);
        event.getModelRegistry().put(laserBladeItemID, bakedModel);
        event.getModelRegistry().put(lBBrokenItemID, bakedModel);
    }

    public static void checkUpdate() {
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("tolaserblade").getMods().get(0)));
        VersionChecker.Status status = result.status;
        if (status == VersionChecker.Status.PENDING || result.target == null) {
            return;
        }
        if (status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED) {
            StringTextComponent modNameHighlighted = new StringTextComponent("ToLaserBlade");
            modNameHighlighted.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            StringTextComponent newVersionHighlighted = new StringTextComponent(result.target.toString());
            newVersionHighlighted.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            ITextComponent message = new TranslationTextComponent("tolaserblade.update.newVersion", new Object[]{modNameHighlighted}).func_150258_a(": ").func_150257_a((ITextComponent)newVersionHighlighted);
            message.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, result.url));
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(message);
        }
    }
}

