/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.integration.jei;

import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.upgrade.LaserBladeUpgrade;
import com.github.iunius118.tolaserblade.item.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Triple;

@JeiPlugin
public class JEIToLaserBladePlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("tolaserblade", "main");

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        registry.addRecipes(this.getUpgradeRecipes(registry.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
    }

    private List<Object> getUpgradeRecipes(IVanillaRecipeFactory factory) {
        ItemStack output;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Triple<Tag<Item>, LaserBladeUpgrade.Type, Function<ItemStack, UpgradeResult>> tag : ModItemTags.getTags()) {
            Object recipe = this.getUpdateAnvilRecipe(factory, (Tag<Item>)((Tag)tag.getLeft()), (Function)tag.getRight());
            if (recipe == null) continue;
            list.add(recipe);
        }
        ItemStack tintedLB = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
        ModItems.LASER_BLADE.setBladeOuterColor(tintedLB, -13421773);
        ModItems.LASER_BLADE.setBladeInnerColor(tintedLB, -10066330);
        ModItems.LASER_BLADE.setGripColor(tintedLB, -10066330);
        List<ItemStack> right = this.getUpgradeRecipes((Tag<Item>)Tags.Items.STAINED_GLASS);
        if (right.size() > 0) {
            output = tintedLB.func_77946_l();
            ModItems.LASER_BLADE.setBladeOuterColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
            list.add(factory.createAnvilRecipe(tintedLB.func_77946_l(), right, Collections.singletonList(output)));
        }
        if ((right = this.getUpgradeRecipes((Tag<Item>)Tags.Items.STAINED_GLASS_PANES)).size() > 0) {
            output = tintedLB.func_77946_l();
            ModItems.LASER_BLADE.setBladeInnerColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
            list.add(factory.createAnvilRecipe(tintedLB.func_77946_l(), right, Collections.singletonList(output)));
        }
        if ((right = this.getUpgradeRecipes((Tag<Item>)ItemTags.field_200035_e)).size() > 0) {
            output = tintedLB.func_77946_l();
            ModItems.LASER_BLADE.setGripColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
            list.add(factory.createAnvilRecipe(tintedLB.func_77946_l(), right, Collections.singletonList(output)));
        }
        return list;
    }

    private Object getUpdateAnvilRecipe(IVanillaRecipeFactory factory, Tag<Item> itemTag, Function<ItemStack, UpgradeResult> upgradeFunc) {
        ImmutableList left;
        List<ItemStack> right = this.getUpgradeRecipes(itemTag);
        ItemStack output = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
        if (right.isEmpty()) {
            return null;
        }
        if (itemTag == ModItemTags.EFFICIENCY_REMOVER) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int maxLevel = Enchantments.field_185305_q.func_77325_b();
            for (int level = Enchantments.field_185305_q.func_77319_d(); level <= maxLevel; ++level) {
                ItemStack efficiencyLB = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
                efficiencyLB.func_77966_a(Enchantments.field_185305_q, level);
                builder.add((Object)efficiencyLB);
            }
            left = builder.build();
            output = upgradeFunc.apply(new ItemStack((IItemProvider)ModItems.LASER_BLADE)).getItemStack();
        } else if (itemTag == ModItemTags.CASING_REPAIR) {
            ItemStack damagedLB = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
            damagedLB.func_196085_b(ModItems.LASER_BLADE.getMaxDamage(damagedLB) - 1);
            left = ImmutableList.of((Object)damagedLB, (Object)new ItemStack((IItemProvider)ModItems.LB_BROKEN));
        } else {
            left = Collections.singletonList(new ItemStack((IItemProvider)ModItems.LASER_BLADE));
            output = upgradeFunc.apply(new ItemStack((IItemProvider)ModItems.LASER_BLADE)).getItemStack();
        }
        return factory.createAnvilRecipe((List)left, right, Collections.singletonList(output));
    }

    private List<ItemStack> getUpgradeRecipes(Tag<Item> itemTag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        itemTag.func_199885_a().forEach(item -> list.add(new ItemStack((IItemProvider)item)));
        return list;
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

