/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.model.SimpleModel;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType0;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType1;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType1009;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType101;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType1108;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType1216;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType217;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType305;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType407;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType504;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType519;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType526;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType606;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType726;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType825;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType903;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeModelType913;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class LaserBladeInternalModelManager {
    private static LaserBladeInternalModelManager instance;
    private final Map<Integer, Supplier<? extends SimpleModel>> models = new HashMap<Integer, Supplier<? extends SimpleModel>>();
    private static final Supplier<? extends SimpleModel> defaultModel;

    public static LaserBladeInternalModelManager renewInstance() {
        instance = new LaserBladeInternalModelManager();
        return instance;
    }

    public static LaserBladeInternalModelManager getInstance() {
        return instance != null ? instance : LaserBladeInternalModelManager.renewInstance();
    }

    private LaserBladeInternalModelManager() {
        this.addInternalModels();
    }

    private void addInternalModels() {
        this.models.put(0, defaultModel);
        this.models.put(1, LaserBladeModelType1::new);
        this.models.put(101, LaserBladeModelType101::new);
        this.models.put(217, LaserBladeModelType217::new);
        this.models.put(305, LaserBladeModelType305::new);
        this.models.put(407, LaserBladeModelType407::new);
        this.models.put(504, LaserBladeModelType504::new);
        this.models.put(519, LaserBladeModelType519::new);
        this.models.put(526, LaserBladeModelType526::new);
        this.models.put(606, LaserBladeModelType606::new);
        this.models.put(726, LaserBladeModelType726::new);
        this.models.put(825, LaserBladeModelType825::new);
        this.models.put(903, LaserBladeModelType903::new);
        this.models.put(913, LaserBladeModelType913::new);
        this.models.put(1009, LaserBladeModelType1009::new);
        this.models.put(1108, LaserBladeModelType1108::new);
        this.models.put(1216, LaserBladeModelType1216::new);
    }

    public void addInternalModel(int index, Supplier<? extends SimpleModel> model) {
        if (model == null) {
            ToLaserBlade.LOGGER.warn("Attempted to add null as internal Laser Blade model #{}.", (Object)index);
            return;
        }
        if (this.models.containsKey(index)) {
            ToLaserBlade.LOGGER.info("Internal Laser Blade model #{} already exists. It will be overwritten.", (Object)index);
        }
        this.models.put(index, model);
    }

    public SimpleModel getModel() {
        int modelType = (Integer)ToLaserBladeConfig.CLIENT.internalModelType.get();
        if (modelType < 0) {
            Calendar calendar = Calendar.getInstance();
            modelType = (calendar.get(2) + 1) * 100 + calendar.get(5);
        }
        return this.models.getOrDefault(modelType, defaultModel).get();
    }

    static {
        defaultModel = LaserBladeModelType0::new;
    }
}

