/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.model.LaserBladeInternalModelManager;
import com.github.iunius118.tolaserblade.client.model.LaserBladeModelHolder;
import com.github.iunius118.tolaserblade.client.model.SimpleModel;
import com.github.iunius118.tolaserblade.client.model.laserblade.LaserBladeOBJModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class LaserBladeItemBakedModel
implements IBakedModel {
    ItemStack itemStack = ItemStack.field_190927_a;
    HandSide primaryHand = HandSide.RIGHT;
    public boolean isBlocking = false;
    private static final ItemCameraTransforms ITEM_TRANSFORMS = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(-8.0f, 0.0f, 0.0f), new Vector3f(-0.55f, 0.315f, 0.6f), new Vector3f(1.1f, 1.1f, 1.1f)), new ItemTransformVec3f(new Vector3f(-8.0f, 0.0f, 0.0f), new Vector3f(0.55f, 0.315f, 0.6f), new Vector3f(1.1f, 1.1f, 1.1f)), new ItemTransformVec3f(new Vector3f(20.0f, 0.0f, 0.0f), new Vector3f(-0.26f, 0.0025f, 0.355f), new Vector3f(0.68f, 0.85f, 0.68f)), new ItemTransformVec3f(new Vector3f(20.0f, 0.0f, 0.0f), new Vector3f(0.415f, 0.0025f, 0.355f), new Vector3f(0.68f, 0.85f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.6f, 0.5f), new Vector3f(1.0f, 1.0f, 1.0f)), new ItemTransformVec3f(new Vector3f(90.0f, 45.0f, -90.0f), new Vector3f(0.16f, -0.475f, 0.0f), new Vector3f(0.9f, 0.9f, 0.9f)), new ItemTransformVec3f(new Vector3f(90.0f, -45.0f, 90.0f), new Vector3f(-0.25f, -0.1f, 0.25f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransformVec3f(new Vector3f(90.0f, -45.0f, 90.0f), new Vector3f(-0.175f, -0.485f, 0.44f), new Vector3f(0.95f, 0.95f, 0.95f)));
    private static final ItemCameraTransforms BLOCKING_RIGHTY_ITEM_TRANSFORMS = new ItemCameraTransforms(LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_188036_k, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_188037_l, new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 60.0f), new Vector3f(-0.4f, -0.15f, 0.6f), new Vector3f(0.68f, 0.85f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 60.0f), new Vector3f(-0.05f, 0.4f, 0.5f), new Vector3f(0.68f, 0.85f, 0.68f)), LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_178353_d, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_178354_e, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_181699_o, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_181700_p);
    private static final ItemCameraTransforms BLOCKING_LEFTY_ITEM_TRANSFORMS = new ItemCameraTransforms(LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_188036_k, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_188037_l, new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 60.0f), new Vector3f(-0.4f, -0.185f, 0.5f), new Vector3f(0.68f, 0.85f, 0.68f)), new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 60.0f), new Vector3f(-0.05f, 0.43f, 0.6f), new Vector3f(0.68f, 0.85f, 0.68f)), LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_178353_d, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_178354_e, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_181699_o, LaserBladeItemBakedModel.ITEM_TRANSFORMS.field_181700_p);

    private LaserBladeItemBakedModel handleItemOverride(ItemStack itemStackIn, HandSide primaryHandIn, boolean isBlockingIn) {
        LaserBladeItemBakedModel newModel = new LaserBladeItemBakedModel();
        newModel.itemStack = itemStackIn;
        newModel.primaryHand = primaryHandIn;
        newModel.isBlocking = isBlockingIn;
        return newModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData modelData) {
        return Collections.emptyList();
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData modelData) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199934_a((IItemProvider)Items.field_151042_j);
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(){

            @Nullable
            public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                if (model instanceof LaserBladeItemBakedModel) {
                    LaserBladeItemBakedModel laserBladeModel = (LaserBladeItemBakedModel)model;
                    boolean isBlocking = false;
                    HandSide handSide = HandSide.RIGHT;
                    if (entityIn != null) {
                        isBlocking = ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer.get() != false && entityIn.func_184587_cr();
                        handSide = entityIn.func_184591_cq();
                    }
                    return laserBladeModel.handleItemOverride(stack, handSide, isBlocking);
                }
                return model;
            }
        };
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
    }

    public ItemCameraTransforms func_177552_f() {
        if (this.isBlocking) {
            if (Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT) {
                return BLOCKING_RIGHTY_ITEM_TRANSFORMS;
            }
            return BLOCKING_LEFTY_ITEM_TRANSFORMS;
        }
        return ITEM_TRANSFORMS;
    }

    public void loadModel(ModelBakeEvent event) {
        SimpleModel model;
        if (((Boolean)ToLaserBladeConfig.CLIENT.useInternalModel.get()).booleanValue()) {
            model = LaserBladeInternalModelManager.getInstance().getModel();
        } else {
            LaserBladeOBJModel objModel = new LaserBladeOBJModel();
            objModel.loadLaserBladeOBJModel(event.getModelLoader());
            model = objModel;
        }
        LaserBladeModelHolder.setModel(model);
    }
}

