/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;

public class SimpleModel {
    public static final ResourceLocation TEXTURE_WHITE = new ResourceLocation("forge", "textures/white.png");

    public void render(ItemStack itemStack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightmapCoord, int overlayColor) {
    }

    protected void renderQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<SimpleQuad> quads, int color, int lightmapCoord, int overlayColor) {
        float alpha = (float)(color >>> 24 & 0xFF) / 255.0f;
        float red = (float)(color >>> 16 & 0xFF) / 255.0f;
        float green = (float)(color >>> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        this.renderQuads(matrixStack, buffer, quads, lightmapCoord, overlayColor, red, green, blue, alpha);
    }

    protected void renderQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<SimpleQuad> quads, int lightmapCoord, int overlayColor, float red, float green, float blue, float alpha) {
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        for (SimpleQuad face : quads) {
            for (int i = 0; i < 4; ++i) {
                SimpleVertex vertex = face.vertices[i];
                Vector4f pos = new Vector4f(vertex.pos);
                pos.func_229372_a_(matrixEntry.func_227870_a_());
                Vector4f vColor = vertex.color;
                Vec2f uv = vertex.uv;
                Vector3f normal = vertex.normal.func_229195_e_();
                normal.func_229188_a_(matrixEntry.func_227872_b_());
                buffer.func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), red * vColor.func_195910_a(), green * vColor.func_195913_b(), blue * vColor.func_195914_c(), alpha * vColor.func_195915_d(), uv.field_189982_i, uv.field_189983_j, overlayColor, lightmapCoord, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
            }
        }
    }

    public ResourceLocation getTexture() {
        return TEXTURE_WHITE;
    }

    public static class SimpleQuad {
        public static final Vector4f COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        public final SimpleVertex[] vertices;

        public SimpleQuad(SimpleVertex vertex1, SimpleVertex vertex2, SimpleVertex vertex3, SimpleVertex vertex4) {
            this.vertices = new SimpleVertex[]{vertex1, vertex2, vertex3, vertex4};
        }

        public SimpleQuad(Vector3f posXYZ1, Vector4f colorRGBA1, Vec2f texUV1, Vector3f normalXYZ1, Vector3f posXYZ2, Vector4f colorRGBA2, Vec2f texUV2, Vector3f normalXYZ2, Vector3f posXYZ3, Vector4f colorRGBA3, Vec2f texUV3, Vector3f normalXYZ3, Vector3f posXYZ4, Vector4f colorRGBA4, Vec2f texUV4, Vector3f normalXYZ4) {
            this(new SimpleVertex(posXYZ1, colorRGBA1, texUV1, normalXYZ1), new SimpleVertex(posXYZ2, colorRGBA2, texUV2, normalXYZ2), new SimpleVertex(posXYZ3, colorRGBA3, texUV3, normalXYZ3), new SimpleVertex(posXYZ4, colorRGBA4, texUV4, normalXYZ4));
        }

        public SimpleQuad(Vector3f posXYZ1, Vector4f colorRGBA1, Vec2f texUV1, Vector3f posXYZ2, Vector4f colorRGBA2, Vec2f texUV2, Vector3f posXYZ3, Vector4f colorRGBA3, Vec2f texUV3, Vector3f posXYZ4, Vector4f colorRGBA4, Vec2f texUV4, Vector3f normalXYZ) {
            this(new SimpleVertex(posXYZ1, colorRGBA1, texUV1, normalXYZ), new SimpleVertex(posXYZ2, colorRGBA2, texUV2, normalXYZ), new SimpleVertex(posXYZ3, colorRGBA3, texUV3, normalXYZ), new SimpleVertex(posXYZ4, colorRGBA4, texUV4, normalXYZ));
        }

        public SimpleQuad(Vector3f posXYZ1, Vec2f texUV1, Vector3f posXYZ2, Vec2f texUV2, Vector3f posXYZ3, Vec2f texUV3, Vector3f posXYZ4, Vec2f texUV4, Vector4f colorRGBA, Vector3f normalXYZ) {
            this(new SimpleVertex(posXYZ1, colorRGBA, texUV1, normalXYZ), new SimpleVertex(posXYZ2, colorRGBA, texUV2, normalXYZ), new SimpleVertex(posXYZ3, colorRGBA, texUV3, normalXYZ), new SimpleVertex(posXYZ4, colorRGBA, texUV4, normalXYZ));
        }

        public SimpleQuad(Vector3f posXYZ1, Vec2f texUV1, Vector3f posXYZ2, Vec2f texUV2, Vector3f posXYZ3, Vec2f texUV3, Vector3f posXYZ4, Vec2f texUV4, Vector3f normalXYZ) {
            this(new SimpleVertex(posXYZ1, COLOR_WHITE, texUV1, normalXYZ), new SimpleVertex(posXYZ2, COLOR_WHITE, texUV2, normalXYZ), new SimpleVertex(posXYZ3, COLOR_WHITE, texUV3, normalXYZ), new SimpleVertex(posXYZ4, COLOR_WHITE, texUV4, normalXYZ));
        }

        public SimpleQuad mirror() {
            return new SimpleQuad(this.vertices[3], this.vertices[2], this.vertices[1], this.vertices[0]);
        }
    }

    public static class SimpleVertex {
        public final Vector3f pos;
        public final Vector4f color;
        public final Vec2f uv;
        public final Vector3f normal;

        public SimpleVertex(Vector3f posXYZ, Vector4f colorRGBA, Vec2f texUV, Vector3f normalXYZ) {
            this.pos = posXYZ;
            this.color = colorRGBA;
            this.uv = texUV;
            this.normal = normalXYZ;
        }
    }
}

