/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.data;

import com.github.iunius118.tolaserblade.enchantment.ModEnchantments;
import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemDurabilityTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TLBAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TLBAdvancementProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    protected void registerAdvancements(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.func_200278_a().func_215092_a(ModItems.LASER_BLADE.setGripColor(new ItemStack((IItemProvider)ModItems.LASER_BLADE), LaserBladeItemBase.LBColor.GRAY.getGripColor()), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main.root.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main.root.description", new Object[0]), new ResourceLocation("textures/block/polished_andesite.png"), FrameType.TASK, false, false, false).func_200275_a("has_redstone", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax})).func_200275_a("has_dx_laser_blade", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ModItems.DX_LASER_BLADE})).func_200275_a("has_laser_blade", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ModItems.LASER_BLADE})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, "tolaserblade:main/root");
        Advancement dxLaserBlade = this.registerItemAdvancement(root, (Item)ModItems.DX_LASER_BLADE, FrameType.TASK, (Item)ModItems.DX_LASER_BLADE, consumer);
        Advancement laserBlade = this.registerItemAdvancement(dxLaserBlade, (Item)ModItems.LASER_BLADE, FrameType.TASK, (Item)ModItems.LASER_BLADE, consumer);
        Advancement lightElement5 = this.registerEnchantmentAdvancement(laserBlade, Items.field_221695_cJ, FrameType.TASK, (Item)ModItems.LASER_BLADE, ModEnchantments.LIGHT_ELEMENT, 5, consumer);
        Advancement lightElement10 = this.registerEnchantmentAdvancement(lightElement5, Items.field_221695_cJ, FrameType.TASK, (Item)ModItems.LASER_BLADE, ModEnchantments.LIGHT_ELEMENT, 10, consumer);
        Advancement attack10 = this.registerAttackUpgradeAdvancement(laserBlade, Items.field_151045_i, FrameType.TASK, (Item)ModItems.LASER_BLADE, 10, (int)ModItems.LASER_BLADE.func_200894_d() + 1, consumer);
        Advancement attack15 = this.registerAttackUpgradeAdvancement(attack10, Items.field_151045_i, FrameType.TASK, (Item)ModItems.LASER_BLADE, 15, (int)ModItems.LASER_BLADE.func_200894_d() + 1, consumer);
        Advancement looting3 = this.registerEnchantmentAdvancement(laserBlade, Items.field_205157_eZ, FrameType.TASK, (Item)ModItems.LASER_BLADE, Enchantments.field_185304_p, 3, consumer);
        JsonObject jsonMaxZero = new JsonObject();
        jsonMaxZero.add("max", (JsonElement)new JsonPrimitive((Number)0));
        Advancement breakLaserBlade = Advancement.Builder.func_200278_a().func_203905_a(laserBlade).func_203902_a((IItemProvider)ModItems.LB_CASING, (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main.break_laser_blade.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main.break_laser_blade.description", new Object[0]), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)1000)).func_200275_a("broke_laser_blade", (ICriterionInstance)ItemDurabilityTrigger.Instance.func_211182_a((ItemPredicate)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)ModItems.LASER_BLADE).func_200310_b(), (MinMaxBounds.IntBound)MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonMaxZero))).func_203904_a(consumer, "tolaserblade:main/break_laser_blade");
        Advancement mending = this.registerEnchantmentAdvancement(laserBlade, Items.field_151156_bN, FrameType.GOAL, (Item)ModItems.LASER_BLADE, Enchantments.field_185296_A, 1, consumer);
    }

    private Advancement registerItemAdvancement(Advancement parent, Item icon, FrameType frameType, Item requirement, Consumer<Advancement> consumer) {
        String name = requirement.getRegistryName().func_110623_a();
        return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a((IItemProvider)icon, (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".description", new Object[0]), null, frameType, true, true, false).func_200275_a("has_" + name, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{requirement})).func_203904_a(consumer, "tolaserblade:main/" + name);
    }

    private Advancement registerEnchantmentAdvancement(Advancement parent, Item icon, FrameType frameType, Item requirement, Enchantment enchantment, int level, Consumer<Advancement> consumer) {
        String name = requirement.getRegistryName().func_110623_a() + "_" + enchantment.getRegistryName().func_110623_a() + "_" + level;
        ItemPredicate itemPredicate = ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)requirement).func_218003_a(new EnchantmentPredicate(enchantment, MinMaxBounds.IntBound.func_211340_b((int)level))).func_200310_b();
        return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a((IItemProvider)icon, (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".description", new Object[0]), null, frameType, true, true, false).func_200275_a("has_" + name, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{itemPredicate})).func_203904_a(consumer, "tolaserblade:main/" + name);
    }

    private Advancement registerAttackUpgradeAdvancement(Advancement parent, Item icon, FrameType frameType, Item requirement, int attackDamage, int baseDamage, Consumer<Advancement> consumer) {
        String name = requirement.getRegistryName().func_110623_a() + "_attack_" + attackDamage;
        Advancement.Builder builder = Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a((IItemProvider)icon, (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.tolaserblade.main." + name + ".description", new Object[0]), null, frameType, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_);
        int i = attackDamage - baseDamage;
        while ((float)i <= 8.0f) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a("ATK", (float)i);
            ItemPredicate itemPredicate = ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)requirement).func_218002_a(nbt).func_200310_b();
            builder.func_200275_a(requirement.getRegistryName().func_110623_a() + "_attack_" + (i + baseDamage), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{itemPredicate}));
            ++i;
        }
        return builder.func_203904_a(consumer, "tolaserblade:main/" + name);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path advancementPath = TLBAdvancementProvider.getPath(path, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        this.registerAdvancements(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "ToLaserBlade Advancements";
    }
}

