/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item.upgrade;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.upgrade.UpgradeResult;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;

public class UpgradeFunctions {
    public static Function<ItemStack, UpgradeResult> getUpgradeEnchantmentFunction(Enchantment enchantment) {
        return stack -> {
            int level = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack);
            int cost = 0;
            if (level < enchantment.func_77325_b()) {
                Map oldEnchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                LinkedHashMap newEnchantments = Maps.newLinkedHashMap();
                oldEnchantments.forEach((e, lvl) -> {
                    if (e.func_191560_c(enchantment) || e.equals(enchantment)) {
                        newEnchantments.put(e, lvl);
                    }
                });
                newEnchantments.put(enchantment, ++level);
                EnchantmentHelper.func_82782_a((Map)newEnchantments, (ItemStack)stack);
                int rate = 1;
                switch (enchantment.func_77324_c()) {
                    case COMMON: 
                    case UNCOMMON: {
                        break;
                    }
                    case RARE: {
                        rate = 2;
                        break;
                    }
                    case VERY_RARE: {
                        rate = 4;
                    }
                }
                cost = Math.max(level * rate, 1);
            }
            return UpgradeResult.of(stack, cost);
        };
    }

    public static Function<ItemStack, UpgradeResult> getRemoveEfficiencyFunction() {
        return stack -> {
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
            int cost = 0;
            if (level > 0) {
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                enchantments.remove(Enchantments.field_185305_q);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                cost = 1;
            }
            return UpgradeResult.of(stack, cost);
        };
    }

    public static Function<ItemStack, UpgradeResult> getUpgradeDamageFunction() {
        return stack -> {
            float attack = ModItems.LASER_BLADE.getLaserBladeATK((ItemStack)stack);
            float maxUpgradeCount = ToLaserBladeConfig.COMMON.maxAttackDamageUpgradeCountInServer.get().intValue();
            int cost = 0;
            if (attack >= 0.0f && attack < maxUpgradeCount) {
                float attack2 = MathHelper.func_76131_a((float)(attack + 1.0f), (float)0.0f, (float)maxUpgradeCount);
                ModItems.LASER_BLADE.setLaserBladeATK((ItemStack)stack, attack2);
                cost = Math.max((int)attack2, 1);
            }
            return UpgradeResult.of(stack, cost);
        };
    }

    public static Function<ItemStack, UpgradeResult> getUpgradeSpeedFunction() {
        return stack -> {
            float speed = ModItems.LASER_BLADE.getLaserBladeSPD((ItemStack)stack);
            int cost = 0;
            if (speed >= 0.0f && speed < 1.2f) {
                float speed2 = MathHelper.func_76131_a((float)(speed + 0.4f), (float)0.0f, (float)1.2f);
                ModItems.LASER_BLADE.setLaserBladeSPD((ItemStack)stack, speed2);
                cost = Math.max((int)(speed2 / 0.4f), 1);
            }
            return UpgradeResult.of(stack, cost);
        };
    }

    public static Function<ItemStack, UpgradeResult> getRepairFunction() {
        return stack -> {
            ItemStack output = stack;
            int cost = 0;
            if (stack.func_77973_b() == ModItems.LB_BROKEN) {
                ItemStack laserBlade = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
                laserBlade.func_77982_d(stack.func_196082_o().func_74737_b());
                laserBlade.func_196085_b(0);
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)laserBlade);
                if (enchantments.containsKey(Enchantments.field_185302_k)) {
                    float atkFromSharpness = Math.max((Integer)enchantments.get(Enchantments.field_185302_k) - 1, 0);
                    float atk = ModItems.LASER_BLADE.getLaserBladeATK(laserBlade);
                    ModItems.LASER_BLADE.setLaserBladeATK(laserBlade, Math.max(atkFromSharpness, atk));
                    enchantments.remove(Enchantments.field_185302_k);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)laserBlade);
                }
                output = laserBlade;
                cost = 1;
            } else if (stack.func_77952_i() > 0) {
                output.func_196085_b(0);
                cost = 1;
            }
            return UpgradeResult.of(output, cost);
        };
    }
}

