/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="burningtorch")
@Config.LangKey(value="burningtorch.config.title")
public class ModConfig {
    @Config.LangKey(value="burningtorch.config.rainupdaterate")
    @Config.Comment(value={"How quickly a torch will react to a storm in ticks, Lower values are faster. 20 ticks = 1 second, 1200 ticks = 1 minute, 72000 ticks = 1 hour"})
    @Config.RangeInt(min=0, max=0x7FFFFFFF)
    public static int rainUpdateRate = 40;
    @Config.LangKey(value="burningtorch.config.burnrate")
    @Config.Comment(value={"How many ticks between decay levels. 20 ticks = 1 second, 1200 ticks = 1 minute, 72000 ticks = 1 hour"})
    @Config.RangeInt(min=0, max=0x7FFFFFFF)
    public static int decayRate = 18000;
    @Config.LangKey(value="burningtorch.config.itemstorelighttorches")
    @Config.Comment(value={"What items can relight a torch."})
    public static String[] relightingItems = new String[1];
    @Config.LangKey(value="burningtorch.config.itemstoextinguish")
    @Config.Comment(value={"What items can extinguish a torch."})
    public static String[] extinguishingingItems;
    @Config.LangKey(value="burningtorch.config.itemstoextend")
    @Config.Comment(value={"What items can add more time to a torch. Number is levels added."})
    public static final Map<String, Integer> extendingingItems;
    @Config.LangKey(value="burningtorch.config.rainextinguish")
    @Config.Comment(value={"Should rain extinguish torches?"})
    public static boolean shouldRainExtinguish;
    @Config.LangKey(value="burningtorch.config.lightatlevel5")
    @Config.Comment(value={"How much light does new torches give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevel5;
    @Config.LangKey(value="burningtorch.config.lightatlevel4")
    @Config.Comment(value={"How much light does an almost new torches give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevel4;
    @Config.LangKey(value="burningtorch.config.lightatlevel3")
    @Config.Comment(value={"How much light does a half used torches give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevel3;
    @Config.LangKey(value="burningtorch.config.lightatlevel2")
    @Config.Comment(value={"How much light does an almost burnt out torches give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevel2;
    @Config.LangKey(value="burningtorch.config.lightatlevel1")
    @Config.Comment(value={"How much light does a burning out torches give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevel1;
    @Config.LangKey(value="burningtorch.config.lightunlit")
    @Config.Comment(value={"How much light does an unlit torch give?"})
    @Config.RangeInt(min=0, max=16)
    public static int lightLevelUnlitTorch;
    @Config.LangKey(value="burningtorch.config.startingdecaylevel")
    @Config.Comment(value={"What decay level do the pumpkin start at?"})
    @Config.RangeInt(min=1, max=5)
    public static int torchStartingDecayLevel;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightatlevel5")
    @Config.Comment(value={"How much light does new pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevel5;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightatlevel4")
    @Config.Comment(value={"How much light does an almost new pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevel4;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightatlevel3")
    @Config.Comment(value={"How much light does a half used pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevel3;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightatlevel2")
    @Config.Comment(value={"How much light does an almost burnt out pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevel2;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightatlevel1")
    @Config.Comment(value={"How much light does a burning out pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevel1;
    @Config.LangKey(value="burningtorch.config.pumpkin.lightunlit")
    @Config.Comment(value={"How much light does an unlit pumpkin give?"})
    @Config.RangeInt(min=0, max=16)
    public static int pumpkinLightLevelUnlit;
    @Config.LangKey(value="burningtorch.config.pumpkin.startingdecaylevel")
    @Config.Comment(value={"What decay level do the pumpkins start at?"})
    @Config.RangeInt(min=1, max=5)
    public static int pumkinStartingDecayLevel;
    @Config.LangKey(value="burningtorch.config.dropeditemswhenbroke")
    @Config.Comment(value={"What is dropped when a torch is broke? Set quantity to 9 for nugget based math."})
    public static final Map<String, Integer> drops;
    @Config.LangKey(value="burningtorch.config.dropeditemswhenvanillabroke")
    @Config.Comment(value={"What is dropped when a vanilla torch is broke?"})
    public static final Map<String, Integer> vanillaDrops;
    @Config.LangKey(value="burningtorch.config.removevanillatorchrecipe")
    @Config.Comment(value={"Should the vanilla torch recipe be removed?"})
    public static boolean removeVanillaTorchRecipe;
    @Config.LangKey(value="burningtorch.config.pumpkin.removevanilladrops")
    @Config.Comment(value={"Should the vanilla Jack O Lantern recipe be removed?"})
    public static boolean removeVanillaJackOLantenRecipe;
    @Config.LangKey(value="burningtorch.config.removevanillatorchdrops")
    @Config.Comment(value={"Should vanilla torches drops be replaced?"})
    public static boolean replaceVanillaTorchDrops;
    @Config.LangKey(value="burningtorch.config.pumpkin.removevanilladrops")
    @Config.Comment(value={"Should vanilla torches drops be replaced?"})
    public static boolean replaceVanillaPumpkinDrops;
    @Config.LangKey(value="burningtorch.config.vanillatorchitemdropchance")
    @Config.Comment(value={"The drop chance for any items we add to vanilla torches."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static Double dropChance;
    @Config.LangKey(value="burningtorch.config.place.unlit")
    @Config.Comment(value={"Toggle whither torches are lit when placed or unlit. true=lit false=unlit"})
    public static boolean placeLitTorches;
    @Config.LangKey(value="burningtorch.config.place.unlit.pumpkin")
    @Config.Comment(value={"Toggle whither pumpkins are lit when placed or unlit. true=lit false=unlit"})
    public static boolean placeLitPumpkins;
    @Config.LangKey(value="burningtorch.config.torchstartsfire")
    @Config.Comment(value={"Toggle whither torches start fires when lit. true=fire false=no fire"})
    public static boolean torchesStartFireWhenLit;
    @Config.LangKey(value="burningtorch.config.torchburnsentities")
    @Config.Comment(value={"Toggle whither torches burn entities when lit. true=burn false=no burn"})
    public static boolean torchesBurnEntities;

    static {
        ModConfig.relightingItems[0] = "minecraft:flint_and_steel";
        extinguishingingItems = new String[1];
        ModConfig.extinguishingingItems[0] = "minecraft:bucket";
        extendingingItems = new HashMap<String, Integer>();
        extendingingItems.put("minecraft:coal", 5);
        extendingingItems.put("minecraft:planks", 1);
        shouldRainExtinguish = true;
        lightLevel5 = 14;
        lightLevel4 = 14;
        lightLevel3 = 14;
        lightLevel2 = 14;
        lightLevel1 = 14;
        lightLevelUnlitTorch = 0;
        torchStartingDecayLevel = 5;
        pumpkinLightLevel5 = 14;
        pumpkinLightLevel4 = 14;
        pumpkinLightLevel3 = 14;
        pumpkinLightLevel2 = 14;
        pumpkinLightLevel1 = 14;
        pumpkinLightLevelUnlit = 0;
        pumkinStartingDecayLevel = 5;
        drops = new HashMap<String, Integer>();
        drops.put("burningtorch:charredtorchremains", 9);
        vanillaDrops = new HashMap<String, Integer>();
        vanillaDrops.put("burningtorch:charredtorchremains", 3);
        removeVanillaTorchRecipe = true;
        removeVanillaJackOLantenRecipe = true;
        replaceVanillaTorchDrops = true;
        replaceVanillaPumpkinDrops = true;
        dropChance = 1.0;
        placeLitTorches = true;
        placeLitPumpkins = true;
        torchesStartFireWhenLit = true;
        torchesBurnEntities = true;
    }

    @Mod.EventBusSubscriber
    public static class SyncConfig {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("burningtorch")) {
                ConfigManager.sync((String)"burningtorch", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

