/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.blocks;

import java.util.Map;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.ModConfig;
import net.doubledoordev.burningtorch.tileentities.PumpkinTorchTE;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBurningPumpkin
extends Block {
    public static final PropertyInteger DECAY = PropertyInteger.func_177719_a((String)"decay", (int)0, (int)5);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"direction");

    public BlockBurningPumpkin(Material materialIn) {
        super(materialIn);
        if (ModConfig.placeLitPumpkins) {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5)));
        } else {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5)));
        }
        this.func_149715_a(0.9375f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        if (ModConfig.placeLitPumpkins) {
            this.func_149663_c("burningpumpkin");
        } else {
            this.func_149663_c("burningpumpkinextinguished");
        }
        this.setRegistryName("burningtorch", "burningpumpkin");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        PumpkinTorchTE pumpkinTE = (PumpkinTorchTE)worldIn.func_175625_s(pos);
        for (String item : ModConfig.relightingItems) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!playerIn.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("item.flintandsteel.use")), SoundCategory.BLOCKS, 0.3f, 0.8f);
            return true;
        }
        for (String item : ModConfig.extinguishingingItems) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!playerIn.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            return true;
        }
        for (Map.Entry entry : ModConfig.extendingingItems.entrySet()) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(entry.getKey()) || pumpkinTE.getDecayLevel() >= 5) continue;
            if ((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) + (Integer)entry.getValue() > 5) {
                pumpkinTE.setDecayLevel(5);
                playerIn.func_184614_ca().func_190920_e(playerIn.func_184614_ca().func_190916_E() - 1);
                worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
                return true;
            }
            pumpkinTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) + (Integer)entry.getValue());
            playerIn.func_184614_ca().func_190920_e(playerIn.func_184614_ca().func_190916_E() - 1);
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            return true;
        }
        if (playerIn.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("entity.sheep.shear")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            pumpkinTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) - 1);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (ModConfig.placeLitPumpkins) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_extinguished", "inventory"));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION, LIT, DECAY});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int decayLevel;
        if (world.func_175625_s(pos) instanceof PumpkinTorchTE) {
            PumpkinTorchTE torchTE = (PumpkinTorchTE)world.func_175625_s(pos);
            decayLevel = torchTE.getDecayLevel();
        } else {
            decayLevel = 5;
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return ModConfig.pumpkinLightLevelUnlit;
        }
        switch (decayLevel) {
            case 5: {
                return ModConfig.pumpkinLightLevel5;
            }
            case 4: {
                return ModConfig.pumpkinLightLevel4;
            }
            case 3: {
                return ModConfig.pumpkinLightLevel3;
            }
            case 2: {
                return ModConfig.pumpkinLightLevel2;
            }
            case 1: {
                return ModConfig.pumpkinLightLevel1;
            }
        }
        return 14;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new PumpkinTorchTE();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int decayLevel;
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (tileentity instanceof PumpkinTorchTE) {
            PumpkinTorchTE torchTE = (PumpkinTorchTE)tileentity;
            decayLevel = torchTE.getDecayLevel();
        } else {
            decayLevel = 0;
        }
        IBlockState blockState = state;
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                block0 : switch (decayLevel) {
                    case 5: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                        break;
                    }
                    case 4: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                        break;
                    }
                    case 3: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                        break;
                    }
                    case 2: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                        break;
                    }
                    case 1: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                        break;
                    }
                    case 0: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                    }
                }
            } else {
                block56 : switch (decayLevel) {
                    case 5: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                        break;
                    }
                    case 4: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                        break;
                    }
                    case 3: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                        break;
                    }
                    case 2: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                        break;
                    }
                    case 1: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                        break;
                    }
                    case 0: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                    }
                }
            }
        }
        return blockState;
    }

    public int func_176201_c(IBlockState state) {
        int d = 0;
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                case NORTH: {
                    d |= 1;
                    break;
                }
                case EAST: {
                    d |= 2;
                    break;
                }
                case WEST: {
                    d |= 3;
                    break;
                }
                case SOUTH: {
                    d |= 4;
                    break;
                }
                case UP: {
                    d |= 5;
                    break;
                }
                case DOWN: {
                    d |= 6;
                    break;
                }
                default: {
                    d |= 5;
                    break;
                }
            }
        } else {
            switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                case NORTH: {
                    d |= 7;
                    break;
                }
                case EAST: {
                    d |= 8;
                    break;
                }
                case WEST: {
                    d |= 9;
                    break;
                }
                case SOUTH: {
                    d |= 0xA;
                    break;
                }
                case UP: {
                    d |= 0xB;
                    break;
                }
                case DOWN: {
                    d |= 0xC;
                    break;
                }
                default: {
                    d |= 0xB;
                }
            }
        }
        return d;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        switch (meta) {
            case 1: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 2: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST);
                break;
            }
            case 3: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST);
                break;
            }
            case 4: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 5: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
                break;
            }
            case 6: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN);
                break;
            }
            case 7: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 8: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST);
                break;
            }
            case 9: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST);
                break;
            }
            case 10: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 11: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
                break;
            }
            case 12: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN);
                break;
            }
            default: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
            }
        }
        return blockState;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        switch ((Integer)this.func_176221_a(state, world, pos).func_177229_b((IProperty)DECAY)) {
            case 5: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 8) {
                        quantity = entry.getValue() - 1;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 4: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 8) {
                        quantity = entry.getValue() - 3;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 3: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 6) {
                        quantity = entry.getValue() - 5;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 2: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 3) {
                        quantity = entry.getValue() - 6;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 1: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 1) {
                        quantity = entry.getValue() - 7;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }
}

