/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.blocks;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.ModConfig;
import net.doubledoordev.burningtorch.tileentities.TorchTE;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBurningTorch
extends Block {
    public static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"direction");
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyInteger DECAY = PropertyInteger.func_177719_a((String)"decay", (int)0, (int)5);
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, 0.8000000238418579, (double)0.6f);
    private static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB(0.399999940395355, (double)0.2f, 0.599999988079071, 0.599999761581421, 1.000100011920929, 1.0);
    private static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, 1.000100011920929, 0.40000001192092893);
    private static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB(0.599999988079071, (double)0.2f, (double)0.35f, 1.0, 1.000100011920929, (double)0.65f);
    private static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, 0.40000001192092893, 1.000100011920929, (double)0.65f);

    public BlockBurningTorch(Material materialIn) {
        super(materialIn);
        if (ModConfig.placeLitTorches) {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5)));
        } else {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5)));
        }
        this.func_149715_a(0.9375f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        if (ModConfig.placeLitTorches) {
            this.func_149663_c("burningtorch");
        } else {
            this.func_149663_c("burningtorchextinguished");
        }
        this.setRegistryName("burningtorch", "burningtorch");
        if (ModConfig.torchesStartFireWhenLit) {
            this.func_149675_a(true);
        } else {
            this.func_149675_a(false);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TorchTE torchTE = (TorchTE)worldIn.func_175625_s(pos);
        for (String item : ModConfig.relightingItems) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!playerIn.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("item.flintandsteel.use")), SoundCategory.BLOCKS, 0.3f, 0.8f);
            return true;
        }
        for (String item : ModConfig.extinguishingingItems) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!playerIn.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            return true;
        }
        for (Map.Entry entry : ModConfig.extendingingItems.entrySet()) {
            if (!playerIn.func_184614_ca().func_77973_b().getRegistryName().toString().equals(entry.getKey()) || torchTE.getDecayLevel() >= 5) continue;
            if ((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) + (Integer)entry.getValue() > 5) {
                torchTE.setDecayLevel(5);
                playerIn.func_184614_ca().func_190920_e(playerIn.func_184614_ca().func_190916_E() - 1);
                worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
                return true;
            }
            torchTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) + (Integer)entry.getValue());
            playerIn.func_184614_ca().func_190920_e(playerIn.func_184614_ca().func_190916_E() - 1);
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("block.redstone_torch.burnout")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            return true;
        }
        if (playerIn.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
            worldIn.func_184133_a(playerIn, pos, new SoundEvent(new ResourceLocation("entity.sheep.shear")), SoundCategory.BLOCKS, 0.2f, 0.8f);
            torchTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)DECAY) - 1);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (ModConfig.placeLitTorches) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_extinguished", "inventory"));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int decayLevel;
        if (world.func_175625_s(pos) instanceof TorchTE) {
            TorchTE torchTE = (TorchTE)world.func_175625_s(pos);
            decayLevel = torchTE.getDecayLevel();
        } else {
            decayLevel = 5;
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return ModConfig.lightLevelUnlitTorch;
        }
        switch (decayLevel) {
            case 5: {
                return ModConfig.lightLevel5;
            }
            case 4: {
                return ModConfig.lightLevel4;
            }
            case 3: {
                return ModConfig.lightLevel3;
            }
            case 2: {
                return ModConfig.lightLevel2;
            }
            case 1: {
                return ModConfig.lightLevel1;
            }
        }
        return 14;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION, LIT, DECAY});
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    private boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)DIRECTION);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
            flag = true;
        }
        if (flag) {
            this.func_180653_a(worldIn, pos, state, 100.0f, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TorchTE torchTE = (TorchTE)worldIn.func_175625_s(pos);
        boolean lit = (Boolean)stateIn.func_177229_b((IProperty)LIT);
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)DIRECTION);
        int decay = torchTE.getDecayLevel();
        double random = Math.random();
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.9;
        double d2 = (double)pos.func_177952_p() + 0.5;
        switch (decay) {
            case 5: {
                d1 = (double)pos.func_177956_o() + 0.9;
                break;
            }
            case 4: {
                d1 = (double)pos.func_177956_o() + 0.85;
                break;
            }
            case 3: {
                d1 = (double)pos.func_177956_o() + 0.75;
                break;
            }
            case 2: {
                d1 = (double)pos.func_177956_o() + 0.62;
                break;
            }
            case 1: {
                d1 = (double)pos.func_177956_o() + 0.44;
                break;
            }
            case 0: {
                d1 = (double)pos.func_177956_o() + 0.35;
            }
        }
        if (lit) {
            if (enumfacing.func_176740_k().func_176722_c()) {
                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                switch (decay) {
                    case 5: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.2 * (double)enumfacing1.func_82601_c(), d1 + 0.2, d2 + 0.2 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.2 * (double)enumfacing1.func_82601_c(), d1 + 0.2, d2 + 0.2 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 4: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.22 * (double)enumfacing1.func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.22 * (double)enumfacing1.func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 3: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.24 * (double)enumfacing1.func_82601_c(), d1 + 0.15, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.24 * (double)enumfacing1.func_82601_c(), d1 + 0.15, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 2: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.3 * (double)enumfacing1.func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.3 * (double)enumfacing1.func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 1: {
                        if (random > 0.5) {
                            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.35 * (double)enumfacing1.func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.35 * (double)enumfacing1.func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                            break;
                        }
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0 + 0.35 * (double)enumfacing1.func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 0: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.1 * (double)enumfacing1.func_82601_c(), d1 + 0.09, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.1 * (double)enumfacing1.func_82601_c(), d1 + 0.09, d2 + 0.3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            } else {
                switch (decay) {
                    case 5: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 4: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 3: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 2: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 1: {
                        if (random > 0.5) {
                            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                            break;
                        }
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case 0: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)DIRECTION))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_180653_a(worldIn, pos, state, 100.0f, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : DIRECTION.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockBurningTorch.func_193382_c((Block)block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TorchTE();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int decayLevel;
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (tileentity instanceof TorchTE) {
            TorchTE torchTE = (TorchTE)tileentity;
            decayLevel = torchTE.getDecayLevel();
        } else {
            decayLevel = 0;
        }
        IBlockState blockState = state;
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                block0 : switch (decayLevel) {
                    case 5: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                        break;
                    }
                    case 4: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                        break;
                    }
                    case 3: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                        break;
                    }
                    case 2: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                        break;
                    }
                    case 1: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                        break;
                    }
                    case 0: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block0;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                    }
                }
            } else {
                block56 : switch (decayLevel) {
                    case 5: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(5));
                        break;
                    }
                    case 4: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(4));
                        break;
                    }
                    case 3: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(3));
                        break;
                    }
                    case 2: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(2));
                        break;
                    }
                    case 1: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(1));
                        break;
                    }
                    case 0: {
                        switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                            case NORTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case EAST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case WEST: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case SOUTH: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case UP: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                            case DOWN: {
                                blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                                break block56;
                            }
                        }
                        blockState = blockState.func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DECAY, (Comparable)Integer.valueOf(0));
                    }
                }
            }
        }
        return blockState;
    }

    public int func_176201_c(IBlockState state) {
        int d = 0;
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                case NORTH: {
                    d |= 1;
                    break;
                }
                case EAST: {
                    d |= 2;
                    break;
                }
                case WEST: {
                    d |= 3;
                    break;
                }
                case SOUTH: {
                    d |= 4;
                    break;
                }
                case UP: {
                    d |= 5;
                    break;
                }
                case DOWN: {
                    d |= 6;
                    break;
                }
                default: {
                    d |= 5;
                    break;
                }
            }
        } else {
            switch ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)) {
                case NORTH: {
                    d |= 7;
                    break;
                }
                case EAST: {
                    d |= 8;
                    break;
                }
                case WEST: {
                    d |= 9;
                    break;
                }
                case SOUTH: {
                    d |= 0xA;
                    break;
                }
                case UP: {
                    d |= 0xB;
                    break;
                }
                case DOWN: {
                    d |= 0xC;
                    break;
                }
                default: {
                    d |= 0xB;
                }
            }
        }
        return d;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        switch (meta) {
            case 1: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 2: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST);
                break;
            }
            case 3: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST);
                break;
            }
            case 4: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 5: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
                break;
            }
            case 6: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN);
                break;
            }
            case 7: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 8: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.EAST);
                break;
            }
            case 9: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.WEST);
                break;
            }
            case 10: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 11: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
                break;
            }
            case 12: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.DOWN);
                break;
            }
            default: {
                blockState = blockState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.UP);
            }
        }
        return blockState;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        switch ((Integer)this.func_176221_a(state, world, pos).func_177229_b((IProperty)DECAY)) {
            case 5: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 8) {
                        quantity = entry.getValue() - 1;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 4: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 8) {
                        quantity = entry.getValue() - 3;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 3: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 6) {
                        quantity = entry.getValue() - 5;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 2: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 3) {
                        quantity = entry.getValue() - 6;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
            case 1: {
                for (Map.Entry<String, Integer> entry : ModConfig.drops.entrySet()) {
                    Item item = Item.func_111206_d((String)entry.getKey());
                    int quantity = entry.getValue();
                    if (entry.getValue() > 1) {
                        quantity = entry.getValue() - 7;
                    }
                    drops.add((Object)new ItemStack(item, quantity));
                }
                break;
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        if (ModConfig.torchesBurnEntities) {
            return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT);
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        block7: {
            if (!worldIn.func_82736_K().func_82766_b("doFireTick")) break block7;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if ((blockpos = blockpos.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177956_o() >= 0 && blockpos.func_177956_o() < worldIn.func_72800_K() && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState block = worldIn.func_180495_p(blockpos);
                    if (block.func_177230_c().isAir(block, (IBlockAccess)worldIn, blockpos)) {
                        if (!this.isSurroundingBlockFlammable(worldIn, blockpos)) continue;
                        worldIn.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!block.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (blockpos1.func_177956_o() >= 0 && blockpos1.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos1)) {
                        return;
                    }
                    if (!worldIn.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn(worldIn, blockpos1)) continue;
                    worldIn.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(World worldIn, BlockPos pos) {
        return (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || worldIn.func_175667_e(pos)) && worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }
}

