/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.BurningTorchConfig;
import net.doubledoordev.burningtorch.tileentities.PumpkinTorchTE;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BurningPumpkinBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty DECAY = IntegerProperty.func_177719_a((String)"decay", (int)0, (int)5);

    public BurningPumpkinBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)DECAY, (Comparable)Integer.valueOf(5))).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean lit = (Boolean)state.func_177229_b((IProperty)LIT);
            if (lit) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public int func_149750_m(BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        PumpkinTorchTE pumpkinTE = (PumpkinTorchTE)worldIn.func_175625_s(pos);
        for (String item : (List)BurningTorchConfig.GENERAL.relightingItems.get()) {
            if (!player.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!player.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        for (String item : (List)BurningTorchConfig.GENERAL.extinguishingingItems.get()) {
            if (!player.func_184614_ca().func_77973_b().getRegistryName().toString().equals(item) && (!player.func_184592_cb().func_77973_b().getRegistryName().toString().equals(item) || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue())) continue;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        for (String itemValue : (List)BurningTorchConfig.GENERAL.extendingItems.get()) {
            String[] splitItemValue = itemValue.split(",");
            if (!player.func_184614_ca().func_77973_b().getRegistryName().toString().equals(splitItemValue[0]) || pumpkinTE.getDecayLevel() >= 5) continue;
            if ((Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)DECAY) + Integer.valueOf(splitItemValue[1]) > 5) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
                pumpkinTE.setDecayLevel(5);
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
                }
                return true;
            }
            pumpkinTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)DECAY) + Integer.valueOf(splitItemValue[1]));
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
            }
            return true;
        }
        if (player.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
            if ((Integer)state.func_177229_b((IProperty)DECAY) > 1) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.2f, 0.8f);
                pumpkinTE.setDecayLevel((Integer)state.func_177229_b((IProperty)DECAY) - 1);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("burningtorch.interact.shears.low", new Object[0]), true);
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (((Boolean)BurningTorchConfig.GENERAL.placeLitPumpkins.get()).booleanValue()) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LIT, DECAY, WATERLOGGED, FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PumpkinTorchTE();
    }
}

