/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BurningTorchConfig {
    public static final General GENERAL;
    static final ForgeConfigSpec spec;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(General::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
    }

    public static class General {
        public ForgeConfigSpec.IntValue rainUpdateRate;
        public ForgeConfigSpec.IntValue decayRate;
        public ForgeConfigSpec.IntValue percentToStartFire;
        public ForgeConfigSpec.IntValue delayBetweenFire;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> relightingItems;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> extinguishingingItems;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> extendingItems;
        public ForgeConfigSpec.BooleanValue shouldRainExtinguish;
        public ForgeConfigSpec.BooleanValue torchesBurnEntities;
        public ForgeConfigSpec.BooleanValue torchesStartFireWhenLit;
        public ForgeConfigSpec.BooleanValue placeLitTorches;
        public ForgeConfigSpec.IntValue torchlightLevel5;
        public ForgeConfigSpec.IntValue torchlightLevel4;
        public ForgeConfigSpec.IntValue torchlightLevel3;
        public ForgeConfigSpec.IntValue torchlightLevel2;
        public ForgeConfigSpec.IntValue torchlightLevel1;
        public ForgeConfigSpec.IntValue torchStartingDecayLevel;
        public ForgeConfigSpec.BooleanValue placeLitPumpkins;
        public ForgeConfigSpec.IntValue pumpkinlightLevel5;
        public ForgeConfigSpec.IntValue pumpkinlightLevel4;
        public ForgeConfigSpec.IntValue pumpkinlightLevel3;
        public ForgeConfigSpec.IntValue pumpkinlightLevel2;
        public ForgeConfigSpec.IntValue pumpkinlightLevel1;
        public ForgeConfigSpec.IntValue pumpkinStartingDecayLevel;

        public static List<? extends String> relightingItemList() {
            return new ArrayList<String>(Arrays.asList("minecraft:flint_and_steel"));
        }

        public static List<? extends String> extinguishingingItemsList() {
            return new ArrayList<String>(Arrays.asList("minecraft:bucket"));
        }

        public static List<? extends String> extendingItemsList() {
            return new ArrayList<String>(Arrays.asList("minecraft:coal,5", "minecraft:planks,1"));
        }

        General(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("General");
            this.rainUpdateRate = builder.comment("How quickly an unprotected torch will react to a storm in ticks, Lower values are faster. 20 ticks = 1 second, 1200 ticks = 1 minute, 72000 ticks = 1 hour").translation("burningtorch.config.rainupdaterate").defineInRange("rainUpdateRate", 40, 1, Integer.MAX_VALUE);
            this.decayRate = builder.comment("How many ticks between decay levels. 20 ticks = 1 second, 1200 ticks = 1 minute, 72000 ticks = 1 hour").translation("burningtorch.config.burnrate").defineInRange("decayRate", 18000, 1, Integer.MAX_VALUE);
            this.shouldRainExtinguish = builder.comment("Should rain extinguish unprotected torches?").translation("burningtorch.config.rainextinguish").define("shouldRainExtinguish", true);
            this.relightingItems = builder.comment("What items can relight a torch.").translation("burningtorch.config.itemstorelighttorches").defineList("relightingItems", General.relightingItemList(), p -> p instanceof String);
            this.extinguishingingItems = builder.comment("What items can extinguish a torch.").translation("burningtorch.config.itemstoextinguish").defineList("extinguishingingItems", General.extinguishingingItemsList(), p -> p instanceof String);
            this.extendingItems = builder.comment("What items can add more time to a torch. Number is levels added.").translation("burningtorch.config.itemstoextend").defineList("extendingItems", General.extendingItemsList(), p -> p instanceof String);
            builder.pop();
            builder.comment("Torch configuration settings").push("Torches");
            this.torchStartingDecayLevel = builder.comment("What decay level do the torches start at?").translation("burningtorch.config.startingdecaylevel").defineInRange("torchStartingDecayLevel", 5, 1, 5);
            this.torchesBurnEntities = builder.comment("Toggle if torches burn entities when lit. true=lit false=unlit").translation("burningtorch.config.torchburnsentities").define("torchesBurnEntities", true);
            this.torchesStartFireWhenLit = builder.comment("Toggle if torches burn entities when lit. true=burn false=no burn").translation("burningtorch.config.torchstartsfire").define("torchesStartFireWhenLit", true);
            this.percentToStartFire = builder.comment("% Chance to start a fire near a torch.").translation("burningtorch.config.percentToStartFire").defineInRange("percentToStartFire", 50, 1, 100);
            this.delayBetweenFire = builder.comment("Delay between the chance for a torch to start a fire in ticks. 20 ticks = 1 second, 1200 ticks = 1 minute, 72000 ticks = 1 hour").translation("burningtorch.config.delayBetweenFire").defineInRange("delayBetweenFire", 40, 1, Integer.MAX_VALUE);
            this.placeLitTorches = builder.comment("Toggle whither torches are lit when placed or unlit. true=lit false=unlit").translation("burningtorch.config.place.unlit").define("placeLitTorches", true);
            this.torchlightLevel5 = builder.comment("How much light does new torches give?").translation("burningtorch.config.lightatlevel5").defineInRange("lightatlevel5", 15, 0, 16);
            this.torchlightLevel4 = builder.comment("How much light does an almost new torches give?").translation("burningtorch.config.lightatlevel4").defineInRange("lightatlevel4", 15, 0, 16);
            this.torchlightLevel3 = builder.comment("How much light does a half used torches give?").translation("burningtorch.config.lightatlevel3").defineInRange("lightatlevel3", 15, 0, 16);
            this.torchlightLevel2 = builder.comment("How much light does an almost burnt out torches give?").translation("burningtorch.config.lightatlevel2").defineInRange("lightatlevel2", 15, 0, 16);
            this.torchlightLevel1 = builder.comment("How much light does a burning out torches give?").translation("burningtorch.config.lightatlevel1").defineInRange("lightatlevel1", 15, 0, 16);
            builder.pop();
            builder.comment("Pumpkin configuration settings").push("Pumpkin");
            this.pumpkinStartingDecayLevel = builder.comment("What decay level do the torches start at?").translation("burningtorch.config.startingdecaylevel").defineInRange("pumpkinStartingDecayLevel", 5, 1, 5);
            this.placeLitPumpkins = builder.comment("Toggle if pumpkins are lit when placed or unlit. true=lit false=unlit").translation("burningtorch.config.place.unlit.pumpkin").define("placeLitPumpkins", true);
            this.pumpkinlightLevel5 = builder.comment("How much light does new torches give?").translation("burningtorch.config.lightatlevel5").defineInRange("lightatlevel5", 15, 0, 16);
            this.pumpkinlightLevel4 = builder.comment("How much light does an almost new torches give?").translation("burningtorch.config.lightatlevel4").defineInRange("lightatlevel4", 15, 0, 16);
            this.pumpkinlightLevel3 = builder.comment("How much light does a half used torches give?").translation("burningtorch.config.lightatlevel3").defineInRange("lightatlevel3", 15, 0, 16);
            this.pumpkinlightLevel2 = builder.comment("How much light does an almost burnt out torches give?").translation("burningtorch.config.lightatlevel2").defineInRange("lightatlevel2", 15, 0, 16);
            this.pumpkinlightLevel1 = builder.comment("How much light does a burning out torches give?").translation("burningtorch.config.lightatlevel1").defineInRange("lightatlevel1", 15, 0, 16);
            builder.pop();
        }
    }
}

