/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import com.google.common.collect.ImmutableMap;
import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederModule;
import de.canitzp.feederhelmet.IHelmetModule;
import de.canitzp.feederhelmet.NBTHelper;
import de.canitzp.feederhelmet.item.ItemFeederModule;
import de.canitzp.feederhelmet.item.ItemPhotosynthesisModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
@Mod(value="feederhelmet")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"feederhelmet");
    public static final RegistryObject<ItemFeederModule> FEEDER_HELMET_MODULE_ITEM = ITEMS.register("feeder_helmet_module", ItemFeederModule::new);
    public static final RegistryObject<ItemPhotosynthesisModule> PHOTOSYNTHESIS_MODULE_ITEM = ITEMS.register("photosynthesis_helmet_module", ItemPhotosynthesisModule::new);
    public static final List<IHelmetModule> MODULES = new ArrayList<IHelmetModule>();
    public static final ItemGroup TAB = new ItemGroup("feederhelmet"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)FEEDER_HELMET_MODULE_ITEM.get());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> stacks) {
            for (IHelmetModule module : MODULES) {
                stacks.add((Object)new ItemStack((IItemProvider)module.getCorrespondingModuleItem()));
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!module.isModuleApplicableTo(item)) continue;
                    ItemStack stack = new ItemStack((IItemProvider)item);
                    CompoundNBT tag = new CompoundNBT();
                    ListNBT modulesList = new ListNBT();
                    modulesList.add((Object)StringNBT.func_229705_a_((String)module.getTagName()));
                    tag.func_218657_a("modules", (INBT)modulesList);
                    stack.func_77982_d(tag);
                    stacks.add((Object)stack);
                }
            }
        }
    };

    public FeederHelmet() {
        MODULES.add(new FeederModule());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FeederConfig.spec);
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().func_190926_b()) {
            for (IHelmetModule module : MODULES) {
                if (!NBTHelper.isModulePresent(module.getTagName(), event.getItemStack())) continue;
                module.renderTooltip(event.getItemStack(), event.getPlayer(), event.getToolTip(), event.getFlags());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld iWorld = event.getWorld();
        if (iWorld instanceof World) {
            World world = (World)iWorld;
            RecipeManager recipeManager = world.func_199532_z();
            HashMap<ResourceLocation, 2> recipesToInject = new HashMap<ResourceLocation, 2>();
            for (final IHelmetModule module : MODULES) {
                for (Item helmet : ForgeRegistries.ITEMS.getValues()) {
                    if (!module.isModuleApplicableTo(helmet)) continue;
                    NonNullList recipeInputItems = NonNullList.func_191196_a();
                    recipeInputItems.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{module.getCorrespondingModuleItem()}));
                    recipeInputItems.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{helmet}));
                    ItemStack recipeOutputStack = new ItemStack((IItemProvider)helmet);
                    ResourceLocation craftingId = new ResourceLocation(MODID, module.getTagName() + "_" + helmet.getRegistryName().func_110623_a());
                    ShapelessRecipe recipe = new ShapelessRecipe(craftingId, "", recipeOutputStack, recipeInputItems){

                        @Nonnull
                        public ItemStack func_77572_b(CraftingInventory inv) {
                            CompoundNBT nbt = new CompoundNBT();
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                ItemStack stack = inv.func_70301_a(i);
                                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || !stack.func_77942_o()) continue;
                                nbt = stack.func_77978_p();
                            }
                            ItemStack out = super.func_77572_b(inv);
                            out.func_77982_d(nbt);
                            NBTHelper.addModule(module.getTagName(), out);
                            return out;
                        }

                        public boolean func_77569_a(CraftingInventory inv, World worldIn) {
                            if (super.func_77569_a(inv, worldIn)) {
                                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                    ItemStack stack = inv.func_70301_a(i);
                                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || !NBTHelper.isModulePresent(module.getTagName(), stack)) continue;
                                    return false;
                                }
                            }
                            return super.func_77569_a(inv, worldIn);
                        }
                    };
                    if (!recipeManager.func_215378_c().noneMatch(resourceLocation -> resourceLocation.equals((Object)craftingId))) continue;
                    recipesToInject.put(craftingId, recipe);
                }
            }
            HashMap map = new HashMap(recipeManager.field_199522_d);
            HashMap<ResourceLocation, 2> craftingRecipes = new HashMap<ResourceLocation, 2>(map.getOrDefault(IRecipeType.field_222149_a, Collections.emptyMap()));
            craftingRecipes.putAll(recipesToInject);
            map.put(IRecipeType.field_222149_a, ImmutableMap.copyOf(craftingRecipes));
            recipeManager.field_199522_d = ImmutableMap.copyOf(map);
        }
    }

    @SubscribeEvent
    public static void updatePlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.func_130014_f_().func_82737_E() % (long)((Integer)FeederConfig.GENERAL.WAIT_TICKS.get()).intValue() == 0L) {
            ItemStack helmetStack = (ItemStack)event.player.field_71071_by.field_70460_b.get(EquipmentSlotType.HEAD.func_188454_b());
            for (IHelmetModule module : MODULES) {
                if (!NBTHelper.isModulePresent(module.getTagName(), helmetStack)) continue;
                module.updatePlayer(event.player, helmetStack);
            }
        }
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getItemInput();
        ItemStack result = event.getItemResult();
        if (toRepair.func_77942_o() && toRepair.func_77978_p().func_150297_b("modules", 9)) {
            CompoundNBT nbt = result.func_77942_o() ? result.func_77978_p() : new CompoundNBT();
            nbt.func_218657_a("modules", toRepair.func_77978_p().func_74781_a("modules"));
            result.func_77982_d(nbt);
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        NonNullList armorInventory = player.field_71071_by.field_70460_b;
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        NonNullList offHandInventory = player.field_71071_by.field_184439_c;
        NonNullList mergedInventory = NonNullList.func_191196_a();
        mergedInventory.addAll((Collection)armorInventory);
        mergedInventory.addAll((Collection)mainInventory);
        mergedInventory.addAll((Collection)offHandInventory);
        for (ItemStack stack : mergedInventory) {
            CompoundNBT tag;
            if (!stack.func_77942_o() || !(tag = stack.func_77978_p()).func_150297_b("AutoFeederHelmet", 1)) continue;
            tag.func_82580_o("AutoFeederHelmet");
            ListNBT modules = tag.func_150295_c("modules", 8);
            modules.add((Object)StringNBT.func_229705_a_((String)"feeder_module"));
            tag.func_218657_a("modules", (INBT)modules);
        }
    }

    public static boolean isItemHelmet(Item item) {
        return item instanceof ArmorItem && ((ArmorItem)item).func_185083_B_() == EquipmentSlotType.HEAD && !((List)FeederConfig.GENERAL.HELMET_BLACKLIST.get()).contains(item.getRegistryName().toString()) || ((List)FeederConfig.GENERAL.HELMET_WHITELIST.get()).contains(item.getRegistryName().toString());
    }

    public static boolean canDamageBeReducedOrEnergyConsumed(@Nonnull ItemStack stack) {
        AtomicBoolean canWork = new AtomicBoolean(false);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyCapability -> {
            if (stack.func_77942_o()) {
                int energy = stack.func_77978_p().func_74762_e("Energy");
                canWork.set(energy >= (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get());
            }
        });
        if (!canWork.get()) {
            if (stack.func_77984_f()) {
                int newDmg = stack.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get();
                canWork.set(newDmg < stack.func_77958_k() || (Boolean)FeederConfig.GENERAL.CAN_BREAK.get() != false);
            } else {
                canWork.set(true);
            }
        }
        return canWork.get();
    }
}

