/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.FeederHelmet;
import de.canitzp.feederhelmet.IHelmetModule;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.ForgeEventFactory;

public class FeederModule
implements IHelmetModule {
    @Override
    public Item getCorrespondingModuleItem() {
        return (Item)FeederHelmet.FEEDER_HELMET_MODULE_ITEM.get();
    }

    @Override
    public String getTagName() {
        return "feeder_module";
    }

    @Override
    public boolean isModuleApplicableTo(Item item) {
        return FeederHelmet.isItemHelmet(item);
    }

    @Override
    public void renderTooltip(@Nonnull ItemStack stack, @Nullable PlayerEntity entityPlayer, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"item.feederhelmet:feeder_helmet_module_installed.text", (Object[])new Object[0]) + TextFormatting.RESET.toString()));
    }

    @Override
    public void updatePlayer(PlayerEntity player, ItemStack helmetStack) {
        if (player.func_71043_e(false) && FeederHelmet.canDamageBeReducedOrEnergyConsumed(helmetStack)) {
            for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
                if (!FeederModule.isStackEatable(inventoryStack) || !FeederModule.canPlayerEat(player, inventoryStack) || !player.func_71043_e(false)) continue;
                AtomicBoolean hasEnergy = new AtomicBoolean(false);
                AtomicBoolean canEat = new AtomicBoolean(false);
                helmetStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
                    int energy1;
                    hasEnergy.set(true);
                    int energyConsumption = (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get();
                    if (helmetStack.func_77942_o() && (energy1 = helmetStack.func_77978_p().func_74762_e("Energy")) >= energyConsumption) {
                        helmetStack.func_77978_p().func_74768_a("Energy", energy1 - energyConsumption);
                        canEat.set(true);
                    }
                });
                if (!hasEnergy.get()) {
                    if (helmetStack.func_77984_f()) {
                        helmetStack.func_196085_b(helmetStack.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get());
                        if (helmetStack.func_77958_k() - helmetStack.func_77952_i() <= 0) {
                            helmetStack.func_190920_e(0);
                        }
                    }
                    canEat.set(true);
                }
                if (!canEat.get()) continue;
                ForgeEventFactory.onItemUseStart((LivingEntity)player, (ItemStack)inventoryStack, (int)0);
                ItemStack result = inventoryStack.func_77973_b().func_77654_b(inventoryStack, player.func_130014_f_(), (LivingEntity)player);
                ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)inventoryStack, (int)0, (ItemStack)result);
            }
        }
    }

    private static boolean isStackEatable(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean isWhitelisted = ((List)FeederConfig.GENERAL.FOOD_WHITELIST.get()).contains(stack.func_77973_b().getRegistryName().toString());
        if (((Boolean)FeederConfig.GENERAL.FOOD_WHITELIST_ONLY.get()).booleanValue()) {
            return isWhitelisted;
        }
        if (((List)FeederConfig.GENERAL.FOOD_BLACKLIST.get()).contains(stack.func_77973_b().getRegistryName().toString())) {
            return false;
        }
        return isWhitelisted || stack.func_77973_b().func_219971_r();
    }

    private static boolean canPlayerEat(PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b().func_219971_r()) {
            if (((Boolean)FeederConfig.GENERAL.WAIT_UNITL_FILL_ALL_HUNGER.get()).booleanValue()) {
                return player.func_71024_bL().func_75116_a() + stack.func_77973_b().func_219967_s().func_221466_a() <= 20 || (Boolean)FeederConfig.GENERAL.IGNORE_WAITING_WHEN_LOW_HEART.get() != false && player.func_110143_aJ() <= 10.0f;
            }
            return true;
        }
        return true;
    }
}

