/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class NBTHelper {
    public static boolean anyModulePresent(ItemStack stack) {
        return !NBTHelper.getModulesList(stack).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isModulePresent(String module, ItemStack stack) {
        if (!stack.func_77942_o()) return false;
        if (stack.func_77978_p().func_150297_b("modules", 9)) {
            if (!stack.func_77978_p().func_150295_c("modules", 8).stream().map(INBT::func_150285_a_).anyMatch(module::equals)) return false;
            return true;
        } else if (!stack.func_77978_p().func_74767_n(module)) return false;
        return true;
    }

    private static ListNBT getModulesList(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        return nbt.func_150297_b("modules", 9) ? nbt.func_150295_c("modules", 8) : new ListNBT();
    }

    private static void setModulesList(ItemStack stack, ListNBT listNBT) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_218657_a("modules", (INBT)listNBT);
        stack.func_77982_d(nbt);
    }

    public static void addModule(String module, ItemStack stack) {
        ListNBT listNBT = NBTHelper.getModulesList(stack);
        if (listNBT.stream().map(INBT::func_150285_a_).noneMatch(module::equals)) {
            listNBT.add((Object)StringNBT.func_229705_a_((String)module));
        }
        NBTHelper.setModulesList(stack, listNBT);
    }

    public static void removeModule(String module, ItemStack stack) {
        ListNBT newListNBT = new ListNBT();
        ListNBT currentListNBT = NBTHelper.getModulesList(stack);
        for (INBT inbt : currentListNBT) {
            if (module.equals(inbt.func_150285_a_())) continue;
            newListNBT.add((Object)inbt);
        }
        NBTHelper.setModulesList(stack, newListNBT);
    }
}

