/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="feederhelmet")
@Config.LangKey(value="config.feederhelmet:config.name")
@Config(modid="feederhelmet")
public class FeederConfig {
    @Config.Comment(value={"How much durability should the helmet use for every food eaten. Unpowered helmets"})
    @Config.Name(value="Durability necessary")
    @Config.RangeInt(min=0, max=64)
    public static int DURABILITY = 1;
    @Config.Comment(value={"How much energy should the helmet use for every food eaten, when it is a powered helmet."})
    @Config.Name(value="Energy necessary")
    @Config.RangeInt(min=0, max=5000)
    public static int ENERGY_CONSUPTION = 10;
    @Config.Comment(value={"Can the helmet break while feeding? If this is false, the helmet stops feeding you when durability to low. Only when the helmet isn't powered by Energy."})
    @Config.Name(value="Can break helmet")
    public static boolean CAN_BREAK_HELMET = false;
    @Config.Comment(value={"Uses more end game items to craft the feeder module."})
    @Config.Name(value="Hard module recipe")
    @Config.RequiresMcRestart
    public static boolean HARD_MODULE_RECIPE = false;
    @Config.Comment(value={"Defines how much ticks are between food checks. 20 ticks = 1 second"})
    @Config.Name(value="Ticks between inventory scan")
    public static int WAIT_TICKS = 20;
    @Config.Comment(value={"Put additional items to craft a helmet with a module in here. Up to 7"})
    @Config.Name(value="Additional crafting items")
    @Config.RequiresMcRestart
    public static String[] ADD_CRAFT_ITEMS = new String[0];
    @Config.Comment(value={"The here stated items can't be used as FeederHelmet"})
    @Config.Name(value="Helmet blacklist")
    @Config.RequiresMcRestart
    public static String[] HELMET_BLACKLIST = new String[0];
    @Config.Comment(value={"The here stated items can be used as Feeder Helmet, even when they aren't helmets at all (You can't put everything in you helmet slot)"})
    @Config.Name(value="Helmet Whitelist")
    @Config.RequiresMcRestart
    public static String[] HELMET_WHITELIST = new String[0];
    @Config.Comment(value={"All here stated items aren't consumable by the FeederHelmet"})
    @Config.Name(value="Food blacklist")
    public static String[] FOOD_BLACKLIST = new String[0];
    @Config.Comment(value={"All here stated items are additionally to all default items eatable. This can be very dangerous, because it is possible that the helmet doesn't eat it, but uses it!!!"})
    @Config.Name(value="Food whitelist")
    public static String[] FOOD_WHITELIST = new String[0];

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("feederhelmet".equals(event.getModID())) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
        }
    }
}

