/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.ItemFeederModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
@Mod(modid="feederhelmet", name="FeederHelmet", version="1.4.1", acceptedMinecraftVersions="1.12,1.12.1,1.12.2")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    public static final String MODNAME = "FeederHelmet";
    public static final String MODVERSION = "1.4.1";
    public static final String MC_VERSIONS = "1.12,1.12.1,1.12.2";
    public static final ItemFeederModule feederModule = new ItemFeederModule();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> reg) {
        reg.getRegistry().register((IForgeRegistryEntry)feederModule);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)feederModule, (int)0, (ModelResourceLocation)new ModelResourceLocation(feederModule.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderTooltips(ItemTooltipEvent event) {
        NBTTagCompound nbt;
        if (!event.getItemStack().func_190926_b() && (nbt = event.getItemStack().func_77978_p()) != null && nbt.func_150297_b("AutoFeederHelmet", 1)) {
            event.getToolTip().add(TextFormatting.YELLOW.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"item.feederhelmet:feeder_helmet_module_installed.text", (Object[])new Object[0]) + TextFormatting.RESET.toString());
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> reg) {
        if (FeederConfig.HARD_MODULE_RECIPE) {
            reg.getRegistry().register(new ShapedOreRecipe(feederModule.getRegistryName(), (Item)feederModule, new Object[]{" r ", "sbs", "iii", Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('s'), "logWood", Character.valueOf('b'), "chest", Character.valueOf('i'), "blockIron"}).setRegistryName(feederModule.getRegistryName()));
        } else {
            reg.getRegistry().register(new ShapedOreRecipe(feederModule.getRegistryName(), (Item)feederModule, new Object[]{" s ", "sbs", "iii", Character.valueOf('s'), "stickWood", Character.valueOf('b'), Items.field_151054_z, Character.valueOf('i'), "ingotIron"}).setRegistryName(feederModule.getRegistryName()));
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_193367_a((Item)feederModule));
        String[] add_craft_items = FeederConfig.ADD_CRAFT_ITEMS;
        Arrays.stream(add_craft_items).limit(7L).map(s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))).filter(Objects::nonNull).map(Ingredient::func_193367_a).forEach(arg_0 -> ingredients.add(arg_0));
        ForgeRegistries.ITEMS.getValuesCollection().stream().filter(FeederHelmet::isItemHelmet).forEach(item -> {
            NonNullList copy = NonNullList.func_191196_a();
            copy.addAll((Collection)ingredients);
            copy.add((Object)Ingredient.func_193367_a((Item)item));
            ItemStack out = new ItemStack(item);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("AutoFeederHelmet", true);
            out.func_77982_d(nbt);
            reg.getRegistry().register(new ShapelessRecipes("feederhelmet:feeder_" + item.func_77658_a(), out, copy){

                @Nonnull
                public ItemStack func_77572_b(InventoryCrafting inv) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor) || !stack.func_77942_o()) continue;
                        nbt = stack.func_77978_p();
                    }
                    ItemStack out = super.func_77572_b(inv);
                    nbt.func_74757_a("AutoFeederHelmet", true);
                    out.func_77982_d(nbt);
                    return out;
                }

                public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
                    if (super.func_77569_a(inv, worldIn)) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            NBTTagCompound nbt;
                            ItemStack stack = inv.func_70301_a(i);
                            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor) || (nbt = stack.func_77978_p()) == null || !nbt.func_150297_b("AutoFeederHelmet", 1)) continue;
                            return false;
                        }
                    }
                    return super.func_77569_a(inv, worldIn);
                }
            }.setRegistryName(MODID, "feeder_" + item.func_77658_a()));
        });
    }

    @SubscribeEvent
    public static void updatePlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.func_130014_f_().func_82737_E() % (long)FeederConfig.WAIT_TICKS == 0L) {
            NBTTagCompound nbt;
            InventoryPlayer inv = event.player.field_71071_by;
            ItemStack helmet = (ItemStack)inv.field_70460_b.get(EntityEquipmentSlot.HEAD.func_188454_b());
            boolean autoFeeder = false;
            if (!helmet.func_190926_b() && helmet.func_77942_o() && FeederHelmet.isItemHelmet(helmet.func_77973_b()) && (nbt = helmet.func_77978_p()).func_150297_b("AutoFeederHelmet", 1)) {
                autoFeeder = true;
            }
            if (autoFeeder && event.player.func_71043_e(false) && FeederHelmet.canWork(helmet)) {
                inv.field_70462_a.stream().filter(FeederHelmet::isStackEatable).forEach(stack -> {
                    if (event.player.func_71043_e(false)) {
                        boolean canEat = false;
                        if (helmet.hasCapability(CapabilityEnergy.ENERGY, null)) {
                            IEnergyStorage energy = (IEnergyStorage)helmet.getCapability(CapabilityEnergy.ENERGY, null);
                            if (energy != null && energy.extractEnergy(FeederConfig.ENERGY_CONSUPTION, true) == FeederConfig.ENERGY_CONSUPTION) {
                                energy.extractEnergy(FeederConfig.ENERGY_CONSUPTION, false);
                                canEat = true;
                            }
                        } else if (helmet.func_77984_f()) {
                            helmet.func_77964_b(helmet.func_77952_i() + FeederConfig.DURABILITY);
                            if (helmet.func_77958_k() - helmet.func_77952_i() <= 0) {
                                helmet.func_190920_e(0);
                            }
                            canEat = true;
                        }
                        if (canEat) {
                            ForgeEventFactory.onItemUseStart((EntityLivingBase)event.player, (ItemStack)stack, (int)0);
                            ItemStack result = stack.func_77973_b().func_77654_b(stack, event.player.field_70170_p, (EntityLivingBase)event.player);
                            ForgeEventFactory.onItemUseFinish((EntityLivingBase)event.player, (ItemStack)stack, (int)0, (ItemStack)result);
                        }
                    }
                });
            }
        }
    }

    private static boolean isItemHelmet(Item item) {
        return item instanceof ItemArmor && ((ItemArmor)item).field_77881_a == EntityEquipmentSlot.HEAD && !ArrayUtils.contains((Object[])FeederConfig.HELMET_BLACKLIST, (Object)item.getRegistryName().toString()) || ArrayUtils.contains((Object[])FeederConfig.HELMET_WHITELIST, (Object)item.getRegistryName().toString());
    }

    private static boolean isStackEatable(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && !ArrayUtils.contains((Object[])FeederConfig.FOOD_BLACKLIST, (Object)stack.func_77973_b().getRegistryName().toString()) && (stack.func_77973_b() instanceof ItemFood || ArrayUtils.contains((Object[])FeederConfig.FOOD_WHITELIST, (Object)stack.func_77973_b().getRegistryName().toString()));
    }

    private static boolean canWork(@Nonnull ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return energy != null && energy.extractEnergy(FeederConfig.ENERGY_CONSUPTION, true) == FeederConfig.ENERGY_CONSUPTION;
        }
        if (stack.func_77984_f()) {
            int newDmg = stack.func_77952_i() + FeederConfig.DURABILITY;
            return newDmg < stack.func_77958_k() || FeederConfig.CAN_BREAK_HELMET;
        }
        return true;
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getItemInput();
        if (toRepair.func_77942_o() && !toRepair.hasCapability(CapabilityEnergy.ENERGY, null) && toRepair.func_77978_p().func_150297_b("AutoFeederHelmet", 1)) {
            ItemStack result = event.getItemResult();
            if (result.func_77942_o()) {
                result.func_77978_p().func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
                result.func_77982_d(nbt);
            }
        }
    }
}

