/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.ItemFeederModule;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="feederhelmet")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    public static final ItemFeederModule feederModule = new ItemFeederModule();

    public FeederHelmet() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FeederConfig.spec);
    }

    private static boolean isItemHelmet(Item item) {
        return item instanceof ItemArmor && ((ItemArmor)item).func_185083_B_() == EntityEquipmentSlot.HEAD && !((List)FeederConfig.GENERAL.HELMET_BLACKLIST.get()).contains(item.getRegistryName().toString()) || ((List)FeederConfig.GENERAL.HELMET_WHITELIST.get()).contains(item.getRegistryName().toString());
    }

    private static boolean isStackEatable(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && !((List)FeederConfig.GENERAL.FOOD_BLACKLIST.get()).contains(stack.func_77973_b().getRegistryName().toString()) && (stack.func_77973_b() instanceof ItemFood || ((List)FeederConfig.GENERAL.FOOD_WHITELIST.get()).contains(stack.func_77973_b().getRegistryName().toString()));
    }

    private static boolean canPlayerEat(EntityPlayer player, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFood) {
            if (((Boolean)FeederConfig.GENERAL.WAIT_UNITL_FILL_ALL_HUNGER.get()).booleanValue()) {
                return player.func_71024_bL().func_75116_a() + ((ItemFood)stack.func_77973_b()).func_150905_g(stack) <= 20;
            }
            return true;
        }
        return true;
    }

    private static boolean canWork(@Nonnull ItemStack stack) {
        AtomicBoolean canWork = new AtomicBoolean(false);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
            int energyConsumption = (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get();
            canWork.set(energy.extractEnergy(energyConsumption, true) == energyConsumption);
        });
        if (!canWork.get() && stack.func_77984_f()) {
            int newDmg = stack.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get();
            canWork.set(newDmg < stack.func_77958_k() || (Boolean)FeederConfig.GENERAL.CAN_BREAK.get() != false);
        }
        return canWork.get();
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getItemInput();
        if (toRepair.func_77942_o() && !toRepair.getCapability(CapabilityEnergy.ENERGY).isPresent() && toRepair.func_77978_p().func_150297_b("AutoFeederHelmet", 1)) {
            ItemStack result = event.getItemResult();
            if (result.func_77942_o()) {
                result.func_77978_p().func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
                result.func_77982_d(nbt);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ForgeEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void renderTooltips(ItemTooltipEvent event) {
            NBTTagCompound nbt;
            if (!event.getItemStack().func_190926_b() && (nbt = event.getItemStack().func_77978_p()) != null && nbt.func_150297_b("AutoFeederHelmet", 1)) {
                event.getToolTip().add(new TextComponentString(TextFormatting.YELLOW.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"item.feederhelmet:feeder_helmet_module_installed.text", (Object[])new Object[0]) + TextFormatting.RESET.toString()));
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            RecipeManager recipeManager = event.getWorld().func_201672_e().func_199532_z();
            NonNullList ingredients = NonNullList.func_191196_a();
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{feederModule}));
            List add_craft_items = (List)FeederConfig.GENERAL.ADD_CRAFT_ITEMS.get();
            add_craft_items.stream().limit(7L).map(s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))).filter(Objects::nonNull).map(xva$0 -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{xva$0})).forEach(arg_0 -> ingredients.add(arg_0));
            ForgeRegistries.ITEMS.getValues().stream().filter(x$0 -> FeederHelmet.isItemHelmet(x$0)).forEach(helmet -> {
                NonNullList ingredientsCopy = NonNullList.func_191196_a();
                ingredientsCopy.addAll((Collection)ingredients);
                ingredientsCopy.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{helmet}));
                ItemStack helmetStack = new ItemStack((IItemProvider)helmet);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("AutoFeederHelmet", true);
                helmetStack.func_77982_d(nbt);
                ResourceLocation craftingId = new ResourceLocation(FeederHelmet.MODID, "feederhelmet_" + helmet.getRegistryName().func_110623_a());
                ShapelessRecipe recipe = new ShapelessRecipe(craftingId, "", helmetStack, ingredientsCopy){

                    @Nonnull
                    public ItemStack func_77572_b(IInventory inv) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack stack = inv.func_70301_a(i);
                            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor) || !stack.func_77942_o()) continue;
                            nbt = stack.func_77978_p();
                        }
                        ItemStack out = super.func_77572_b(inv);
                        nbt.func_74757_a("AutoFeederHelmet", true);
                        out.func_77982_d(nbt);
                        return out;
                    }

                    public boolean func_77569_a(IInventory inv, World worldIn) {
                        if (super.func_77569_a(inv, worldIn)) {
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                NBTTagCompound nbt;
                                ItemStack stack = inv.func_70301_a(i);
                                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor) || (nbt = stack.func_77978_p()) == null || !nbt.func_150297_b("AutoFeederHelmet", 1)) continue;
                                return false;
                            }
                        }
                        return super.func_77569_a(inv, worldIn);
                    }
                };
                if (!recipeManager.func_199511_c().contains(craftingId)) {
                    recipeManager.func_199509_a((IRecipe)recipe);
                }
            });
        }

        @SubscribeEvent
        public static void updatePlayer(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.player.func_130014_f_().func_82737_E() % (long)((Integer)FeederConfig.GENERAL.WAIT_TICKS.get()).intValue() == 0L) {
                NBTTagCompound nbt;
                InventoryPlayer inv = event.player.field_71071_by;
                ItemStack helmet = (ItemStack)inv.field_70460_b.get(EntityEquipmentSlot.HEAD.func_188454_b());
                boolean autoFeeder = false;
                if (!helmet.func_190926_b() && helmet.func_77942_o() && FeederHelmet.isItemHelmet(helmet.func_77973_b()) && (nbt = helmet.func_77978_p()).func_150297_b("AutoFeederHelmet", 1)) {
                    autoFeeder = true;
                }
                if (autoFeeder && event.player.func_71043_e(false) && FeederHelmet.canWork(helmet)) {
                    inv.field_70462_a.stream().filter(x$0 -> FeederHelmet.isStackEatable(x$0)).filter(stack -> FeederHelmet.canPlayerEat(event.player, stack)).forEach(stack -> {
                        if (event.player.func_71043_e(false)) {
                            AtomicBoolean hasEnergy = new AtomicBoolean(false);
                            AtomicBoolean canEat = new AtomicBoolean(false);
                            helmet.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
                                hasEnergy.set(true);
                                int energyConsumption = (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get();
                                if (energy.extractEnergy(energyConsumption, true) == energyConsumption) {
                                    energy.extractEnergy(energyConsumption, false);
                                    canEat.set(true);
                                }
                            });
                            if (!hasEnergy.get() && helmet.func_77984_f()) {
                                helmet.func_196085_b(helmet.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get());
                                if (helmet.func_77958_k() - helmet.func_77952_i() <= 0) {
                                    helmet.func_190920_e(0);
                                }
                                canEat.set(true);
                            }
                            if (canEat.get()) {
                                stack.func_77973_b().func_77654_b(stack, event.player.field_70170_p, (EntityLivingBase)event.player);
                            }
                        }
                    });
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> reg) {
            reg.getRegistry().register((IForgeRegistryEntry)feederModule);
        }
    }
}

