/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import com.google.common.collect.ImmutableMap;
import de.canitzp.feederhelmet.FeederConfig;
import de.canitzp.feederhelmet.ItemFeederModule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="feederhelmet")
public class FeederHelmet {
    public static final String MODID = "feederhelmet";
    public static final ItemFeederModule feederModule = new ItemFeederModule();
    public static final ItemGroup TAB = new ItemGroup("feederhelmet"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)feederModule);
        }

        public void func_78018_a(NonNullList<ItemStack> stacks) {
            stacks.add((Object)new ItemStack((IItemProvider)feederModule));
            for (Item item : ForgeRegistries.ITEMS) {
                if (!FeederHelmet.isItemHelmet(item)) continue;
                ItemStack stack = new ItemStack((IItemProvider)item);
                CompoundNBT tag = new CompoundNBT();
                tag.func_74757_a("AutoFeederHelmet", true);
                stack.func_77982_d(tag);
                stacks.add((Object)stack);
            }
        }
    };

    public FeederHelmet() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FeederConfig.spec);
    }

    private static boolean isItemHelmet(Item item) {
        return item instanceof ArmorItem && ((ArmorItem)item).func_185083_B_() == EquipmentSlotType.HEAD && !((List)FeederConfig.GENERAL.HELMET_BLACKLIST.get()).contains(item.getRegistryName().toString()) || ((List)FeederConfig.GENERAL.HELMET_WHITELIST.get()).contains(item.getRegistryName().toString());
    }

    private static boolean isStackEatable(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && !((List)FeederConfig.GENERAL.FOOD_BLACKLIST.get()).contains(stack.func_77973_b().getRegistryName().toString()) && (stack.func_77973_b().func_219971_r() || ((List)FeederConfig.GENERAL.FOOD_WHITELIST.get()).contains(stack.func_77973_b().getRegistryName().toString()));
    }

    private static boolean canPlayerEat(PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b().func_219971_r()) {
            if (((Boolean)FeederConfig.GENERAL.WAIT_UNITL_FILL_ALL_HUNGER.get()).booleanValue()) {
                return player.func_71024_bL().func_75116_a() + stack.func_77973_b().func_219967_s().func_221466_a() <= 20;
            }
            return true;
        }
        return true;
    }

    private static boolean canWork(@Nonnull ItemStack stack) {
        AtomicBoolean canWork = new AtomicBoolean(false);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
            int energyConsumption = (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get();
            canWork.set(energy.extractEnergy(energyConsumption, true) == energyConsumption);
        });
        if (!canWork.get() && stack.func_77984_f()) {
            int newDmg = stack.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get();
            canWork.set(newDmg < stack.func_77958_k() || (Boolean)FeederConfig.GENERAL.CAN_BREAK.get() != false);
        }
        return canWork.get();
    }

    @SubscribeEvent
    public static void anvilRepair(AnvilRepairEvent event) {
        ItemStack toRepair = event.getItemInput();
        if (toRepair.func_77942_o() && !toRepair.getCapability(CapabilityEnergy.ENERGY).isPresent() && toRepair.func_77978_p().func_150297_b("AutoFeederHelmet", 1)) {
            ItemStack result = event.getItemResult();
            if (result.func_77942_o()) {
                result.func_77978_p().func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
            } else {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("AutoFeederHelmet", toRepair.func_77978_p().func_74767_n("AutoFeederHelmet"));
                result.func_77982_d(nbt);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class ForgeEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void renderTooltips(ItemTooltipEvent event) {
            CompoundNBT nbt;
            if (!event.getItemStack().func_190926_b() && (nbt = event.getItemStack().func_77978_p()) != null && nbt.func_150297_b("AutoFeederHelmet", 1)) {
                event.getToolTip().add(new StringTextComponent(TextFormatting.YELLOW.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"item.feederhelmet:feeder_helmet_module_installed.text", (Object[])new Object[0]) + TextFormatting.RESET.toString()));
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            RecipeManager recipeManager = event.getWorld().func_201672_e().func_199532_z();
            NonNullList ingredients = NonNullList.func_191196_a();
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{feederModule}));
            List add_craft_items = (List)FeederConfig.GENERAL.ADD_CRAFT_ITEMS.get();
            add_craft_items.stream().limit(7L).map(s -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))).filter(Objects::nonNull).map(xva$0 -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{xva$0})).forEach(arg_0 -> ingredients.add(arg_0));
            HashMap recipesToInject = new HashMap();
            ForgeRegistries.ITEMS.getValues().stream().filter(x$0 -> FeederHelmet.isItemHelmet(x$0)).forEach(helmet -> {
                NonNullList ingredientsCopy = NonNullList.func_191196_a();
                ingredientsCopy.addAll((Collection)ingredients);
                ingredientsCopy.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{helmet}));
                ItemStack helmetStack = new ItemStack((IItemProvider)helmet);
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("AutoFeederHelmet", true);
                helmetStack.func_77982_d(nbt);
                ResourceLocation craftingId = new ResourceLocation(FeederHelmet.MODID, "feederhelmet_" + helmet.getRegistryName().func_110623_a());
                ShapelessRecipe recipe = new ShapelessRecipe(craftingId, "", helmetStack, ingredientsCopy){

                    @Nonnull
                    public ItemStack func_77572_b(CraftingInventory inv) {
                        CompoundNBT nbt = new CompoundNBT();
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack stack = inv.func_70301_a(i);
                            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || !stack.func_77942_o()) continue;
                            nbt = stack.func_77978_p();
                        }
                        ItemStack out = super.func_77572_b(inv);
                        nbt.func_74757_a("AutoFeederHelmet", true);
                        out.func_77982_d(nbt);
                        return out;
                    }

                    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
                        if (super.func_77569_a(inv, worldIn)) {
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                CompoundNBT nbt;
                                ItemStack stack = inv.func_70301_a(i);
                                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem) || (nbt = stack.func_77978_p()) == null || !nbt.func_150297_b("AutoFeederHelmet", 1)) continue;
                                return false;
                            }
                        }
                        return super.func_77569_a(inv, worldIn);
                    }
                };
                if (recipeManager.func_215378_c().noneMatch(resourceLocation -> resourceLocation.equals((Object)craftingId))) {
                    recipesToInject.put(craftingId, recipe);
                }
            });
            HashMap map = new HashMap(recipeManager.field_199522_d);
            HashMap craftingRecipes = new HashMap(map.getOrDefault(IRecipeType.field_222149_a, Collections.emptyMap()));
            craftingRecipes.putAll(recipesToInject);
            map.put(IRecipeType.field_222149_a, ImmutableMap.copyOf(craftingRecipes));
            recipeManager.field_199522_d = ImmutableMap.copyOf(map);
        }

        @SubscribeEvent
        public static void updatePlayer(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.player.func_130014_f_().func_82737_E() % (long)((Integer)FeederConfig.GENERAL.WAIT_TICKS.get()).intValue() == 0L) {
                CompoundNBT nbt;
                PlayerInventory inv = event.player.field_71071_by;
                ItemStack helmet = (ItemStack)inv.field_70460_b.get(EquipmentSlotType.HEAD.func_188454_b());
                boolean autoFeeder = false;
                if (!helmet.func_190926_b() && helmet.func_77942_o() && FeederHelmet.isItemHelmet(helmet.func_77973_b()) && (nbt = helmet.func_77978_p()).func_150297_b("AutoFeederHelmet", 1)) {
                    autoFeeder = true;
                }
                if (autoFeeder && event.player.func_71043_e(false) && FeederHelmet.canWork(helmet)) {
                    inv.field_70462_a.stream().filter(x$0 -> FeederHelmet.isStackEatable(x$0)).filter(stack -> FeederHelmet.canPlayerEat(event.player, stack)).forEach(stack -> {
                        if (event.player.func_71043_e(false)) {
                            AtomicBoolean hasEnergy = new AtomicBoolean(false);
                            AtomicBoolean canEat = new AtomicBoolean(false);
                            helmet.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> {
                                hasEnergy.set(true);
                                int energyConsumption = (Integer)FeederConfig.GENERAL.ENERGY_CONSUMPTION.get();
                                if (energy.extractEnergy(energyConsumption, true) == energyConsumption) {
                                    energy.extractEnergy(energyConsumption, false);
                                    canEat.set(true);
                                }
                            });
                            if (!hasEnergy.get() && helmet.func_77984_f()) {
                                helmet.func_196085_b(helmet.func_77952_i() + (Integer)FeederConfig.GENERAL.DURABILITY.get());
                                if (helmet.func_77958_k() - helmet.func_77952_i() <= 0) {
                                    helmet.func_190920_e(0);
                                }
                                canEat.set(true);
                            }
                            if (canEat.get()) {
                                ForgeEventFactory.onItemUseStart((LivingEntity)event.player, (ItemStack)stack, (int)0);
                                ItemStack result = stack.func_77973_b().func_77654_b(stack, event.player.field_70170_p, (LivingEntity)event.player);
                                ForgeEventFactory.onItemUseFinish((LivingEntity)event.player, (ItemStack)stack, (int)0, (ItemStack)result);
                            }
                        }
                    });
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> reg) {
            reg.getRegistry().register((IForgeRegistryEntry)feederModule);
        }
    }
}

